<div wire:poll.5s>
    <div class="space-y-4">
        <!-- Pending Visits for Nurses -->
        <!--[if BLOCK]><![endif]--><?php if(auth()->user()->isNurse() && $pendingVisitsForNurse->count() > 0): ?>
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Patients Waiting for Vitals</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-yellow-100 text-yellow-800 rounded-full"><?php echo e($pendingVisitsForNurse->count()); ?></span>
                </div>
                <div class="space-y-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pendingVisitsForNurse->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('nursing.vitals')); ?>" class="flex items-center justify-between p-2 bg-gray-50 rounded-lg hover:bg-yellow-50 transition-colors">
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e(ucwords(strtolower($visit->patient->full_name))); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($visit->visit_number); ?> • <?php echo e($visit->checked_in_at->diffForHumans()); ?></p>
                            </div>
                            <span class="text-xs font-semibold text-yellow-600">→</span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <!--[if BLOCK]><![endif]--><?php if($pendingVisitsForNurse->count() > 5): ?>
                    <a href="<?php echo e(route('nursing.vitals')); ?>" class="block text-center text-xs text-yellow-600 hover:text-yellow-700 font-medium py-2 mt-2">
                        +<?php echo e($pendingVisitsForNurse->count() - 5); ?> more →
                    </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Pending Visits for Doctors -->
        <?php if(auth()->user()->isDoctor() && $pendingVisitsForDoctor->count() > 0): ?>
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Patients Waiting for Consultation</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-orange-100 text-orange-800 rounded-full"><?php echo e($pendingVisitsForDoctor->count()); ?></span>
                </div>
                <div class="space-y-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pendingVisitsForDoctor->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('doctor.consultations')); ?>" class="flex items-center justify-between p-2 bg-gray-50 rounded-lg hover:bg-orange-50 transition-colors">
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e(ucwords(strtolower($visit->patient->full_name))); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($visit->visit_number); ?> • <?php echo e($visit->checked_in_at->diffForHumans()); ?></p>
                            </div>
                            <span class="text-xs font-semibold text-orange-600">→</span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <!--[if BLOCK]><![endif]--><?php if($pendingVisitsForDoctor->count() > 5): ?>
                    <a href="<?php echo e(route('doctor.consultations')); ?>" class="block text-center text-xs text-orange-600 hover:text-orange-700 font-medium py-2 mt-2">
                        +<?php echo e($pendingVisitsForDoctor->count() - 5); ?> more →
                    </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        
        <!-- Pending Bills -->
        <!--[if BLOCK]><![endif]--><?php if(!auth()->user()->isNurse() && !auth()->user()->isDoctor() && $pendingBills->count() > 0): ?>
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Pending Bills</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-amber-100 text-amber-800 rounded-full"><?php echo e($pendingBills->count()); ?></span>
                </div>
                <div class="space-y-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pendingBills->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-2 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e(ucwords(strtolower($bill->patient->full_name))); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($bill->bill_number); ?></p>
                            </div>
                            <span class="text-sm font-semibold text-amber-600"><?php echo e(config('app.currency_symbol')); ?><?php echo e(number_format($bill->total_amount, 2)); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <!--[if BLOCK]><![endif]--><?php if($pendingBills->count() > 3): ?>
                    <a href="<?php echo e(route('bills.index')); ?>" class="block text-center text-xs text-amber-600 hover:text-amber-700 font-medium py-2 mt-2">
                        +<?php echo e($pendingBills->count() - 3); ?> more →
                    </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Upcoming Appointments to Confirm -->
        <?php if(!auth()->user()->isNurse() && !auth()->user()->isDoctor() && $pendingAppointments->count() > 0): ?>
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Appointments to Confirm</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-blue-100 text-blue-800 rounded-full"><?php echo e($pendingAppointments->count()); ?></span>
                </div>
                <div class="space-y-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $pendingAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-2 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e(ucwords(strtolower($appointment->patient_name))); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($appointment->appointment_date->format('M d')); ?> at <?php echo e(\Carbon\Carbon::parse($appointment->appointment_time)->format('h:i A')); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!--[if BLOCK]><![endif]--><?php if($totalPending === 0 && $pendingAppointments->count() === 0 && $pendingVisitsForNurse->count() === 0 && $pendingVisitsForDoctor->count() === 0): ?>
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="mt-2 text-sm font-medium text-gray-900">All caught up!</p>
                <p class="mt-1 text-sm text-gray-500">No pending tasks at this time.</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div><?php /**PATH /var/www/html/health/resources/views/livewire/dashboard/pending-tasks.blade.php ENDPATH**/ ?>