<?php

use Illuminate\Support\Facades\Route;

Route::redirect('/', '/login');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

// Health Management Routes
Route::middleware(['auth'])->group(function () {
    // Patient Management - using traditional Livewire components
    Route::get('/patients', \App\Livewire\Patients\PatientList::class)->name('patients.index');
    Route::get('/patients/create', \App\Livewire\Patients\PatientRegistration::class)->name('patients.create');
    Route::get('/patients/{patient}', \App\Livewire\Patients\PatientProfile::class)->name('patients.show');
    
    // Visit Management - Core workflow
    Route::get('/visits', \App\Livewire\Visits\VisitList::class)->name('visits.index');
    Route::get('/visits/{visit}', \App\Livewire\Visits\VisitShow::class)->name('visits.show');
    
    // Nursing Station
    Route::get('/nursing/vitals', \App\Livewire\Nursing\NursingVitals::class)->name('nursing.vitals');
    Route::get('/medications/log', \App\Livewire\Nursing\MedicationAdministrationLog::class)->name('medications.log');
    
    // Doctor Consultation
    Route::get('/doctor/consultations', \App\Livewire\Consultations\DoctorConsultation::class)->name('doctor.consultations');
    
    // Laboratory
    Route::get('/lab/workflow', \App\Livewire\Labs\LabWorkflow::class)->name('lab.workflow');
    
    // Visit Billing & Checkout
    Route::get('/billing/visits', \App\Livewire\Visits\VisitBilling::class)->name('billing.visits');
    
    // Dashboard for health management
    Route::view('/health-dashboard', 'health-dashboard')->name('health.dashboard');
    Route::view('/hospital-dashboard', 'hospital-dashboard')->name('hospital.dashboard');
    
    // AI Features
    Route::get('/ai/drug-interactions', \App\Livewire\AI\AIDrugInteractionChecker::class)->name('ai.drug-interactions');
    Route::get('/ai/diagnosis-assistant', \App\Livewire\AI\AIDiagnosisAssistant::class)->name('ai.diagnosis-assistant');
    
    // Hospital Modules
    Route::get('/appointments', \App\Livewire\Appointments\AppointmentList::class)->name('appointments.index');
    Route::get('/prescriptions', \App\Livewire\Pharmacy\PrescriptionList::class)->name('prescriptions.index');
    Route::get('/bills', \App\Livewire\Billing\BillList::class)->name('bills.index');
    Route::get('/consultations', \App\Livewire\Consultations\ConsultationList::class)->name('consultations.index');
    Route::get('/admissions', \App\Livewire\Admissions\AdmissionList::class)->name('admissions.index');
    Route::get('/surgeries', \App\Livewire\Surgery\SurgeryList::class)->name('surgeries.index');
    
    // Service Management - Only for CMD and Developer
    Route::get('/services', \App\Livewire\Services\ServiceManagement::class)->name('services.index');
    
    // Drug Management - For Pharmacy, Developer, and CMD
    Route::get('/drugs', \App\Livewire\Pharmacy\DrugManagement::class)->name('drugs.index');
Route::get('/drugs/{id}', \App\Livewire\Pharmacy\DrugDetail::class)->name('drugs.show');
    
    // Inventory Management - For Pharmacy, Developer, and CMD
    Route::get('/inventory', \App\Livewire\Pharmacy\InventoryManagement::class)->name('inventory.index');
});

require __DIR__.'/auth.php';
