<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="mb-4">
            <a href="{{ route('visits.index') }}" class="text-indigo-600 hover:text-indigo-900 inline-flex items-center">
                <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Visits
            </a>
        </div>

        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <!-- Header -->
                <div class="flex justify-between items-start mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Visit Details</h2>
                        <p class="text-gray-600 mt-1">Visit Number: {{ $visit->visit_number }}</p>
                    </div>
                    <div>
                        <span class="px-3 py-1 text-sm font-semibold rounded-full bg-{{ $visit->status_color }}-100 text-{{ $visit->status_color }}-800">
                            {{ $visit->status_label }}
                        </span>
                    </div>
                </div>

                <!-- Patient Information -->
                <div class="bg-gray-50 rounded-lg p-4 mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Patient Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Name</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $visit->patient->full_name }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Patient ID</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $visit->patient->patient_id }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $visit->patient->date_of_birth->format('M d, Y') }} (Age: {{ $visit->patient->age }})</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Gender</label>
                            <p class="mt-1 text-sm text-gray-900">{{ ucfirst($visit->patient->gender) }}</p>
                        </div>
                    </div>
                </div>

                <!-- Visit Information -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Visit Information</h3>
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Checked In</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $visit->checked_in_at->format('M d, Y h:i A') }}</p>
                            </div>
                            @if($visit->checked_out_at)
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Checked Out</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $visit->checked_out_at->format('M d, Y h:i A') }}</p>
                            </div>
                            @endif
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Checked In By</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $visit->createdBy->name }}</p>
                            </div>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-3">Chief Complaint</h3>
                        <p class="text-sm text-gray-900">{{ $visit->chief_complaint ?? 'N/A' }}</p>
                        @if($visit->visit_notes)
                        <div class="mt-4">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Visit Notes</label>
                            <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $visit->visit_notes }}</p>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Consultations -->
                @if($visit->consultations->count() > 0)
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Consultations</h3>
                    <div class="space-y-4">
                        @foreach($visit->consultations as $consultation)
                        <div class="border border-gray-200 rounded-lg p-4">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <p class="font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $consultation->consultation_type)) }}</p>
                                    <p class="text-sm text-gray-500">By: {{ $consultation->doctor->name ?? 'N/A' }}</p>
                                </div>
                                <span class="text-sm text-gray-500">{{ $consultation->created_at->format('M d, Y h:i A') }}</span>
                            </div>
                            @if($consultation->diagnosis)
                            <div class="mt-2">
                                <label class="block text-sm font-medium text-gray-700">Diagnosis</label>
                                <p class="text-sm text-gray-900">{{ $consultation->diagnosis }}</p>
                            </div>
                            @endif
                            @if($consultation->treatment_plan)
                            <div class="mt-2">
                                <label class="block text-sm font-medium text-gray-700">Treatment Plan</label>
                                <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $consultation->treatment_plan }}</p>
                            </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Prescriptions -->
                @if($visit->prescriptions->count() > 0)
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Prescriptions</h3>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Drug</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Dosage</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Frequency</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Duration</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($visit->prescriptions as $prescription)
                                <tr>
                                    <td class="px-4 py-3 text-sm text-gray-900">{{ $prescription->drug->name ?? 'N/A' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-500">{{ $prescription->dosage }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-500">{{ $prescription->frequency }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-500">{{ $prescription->duration }}</td>
                                    <td class="px-4 py-3 text-sm">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $prescription->status === 'fulfilled' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ ucfirst($prescription->status) }}
                                        </span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif

                <!-- Lab Requests -->
                @if($visit->labRequests->count() > 0)
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Lab Requests</h3>
                    <div class="space-y-3">
                        @foreach($visit->labRequests as $labRequest)
                        <div class="border border-gray-200 rounded-lg p-4">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <p class="font-medium text-gray-900">{{ $labRequest->test_name }}</p>
                                    <p class="text-sm text-gray-500">{{ $labRequest->test_type }}</p>
                                </div>
                                <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                    {{ $labRequest->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                       ($labRequest->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">
                                    {{ ucfirst($labRequest->status) }}
                                </span>
                            </div>
                            @if($labRequest->results)
                            <div class="mt-2">
                                <label class="block text-sm font-medium text-gray-700">Results</label>
                                <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $labRequest->results }}</p>
                            </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Bills -->
                @if($visit->bills->count() > 0)
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Bills</h3>
                    <div class="space-y-4">
                        @foreach($visit->bills as $bill)
                        <div class="border border-gray-200 rounded-lg p-4">
                            <div class="flex justify-between items-start mb-3">
                                <div>
                                    <p class="font-medium text-gray-900">Bill #{{ $bill->bill_number }}</p>
                                    <p class="text-sm text-gray-500">{{ $bill->created_at->format('M d, Y h:i A') }}</p>
                                </div>
                                <div class="text-right">
                                    <p class="text-lg font-semibold text-gray-900">₦{{ number_format($bill->total_amount, 2) }}</p>
                                    <p class="text-sm text-gray-500">Balance: ₦{{ number_format($bill->balance, 2) }}</p>
                                </div>
                            </div>
                            @if($bill->payments->count() > 0)
                            <div class="mt-3 pt-3 border-t">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Payments</label>
                                <div class="space-y-2">
                                    @foreach($bill->payments as $payment)
                                    <div class="flex justify-between text-sm">
                                        <span class="text-gray-600">{{ $payment->payment_method }} - {{ $payment->created_at->format('M d, Y') }}</span>
                                        <span class="text-gray-900">₦{{ number_format($payment->amount, 2) }}</span>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Admission -->
                @if($visit->admission)
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Admission</h3>
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Admission Date</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $visit->admission->admission_date->format('M d, Y') }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Status</label>
                                <p class="mt-1 text-sm text-gray-900">{{ ucfirst($visit->admission->status) }}</p>
                            </div>
                            @if($visit->admission->discharge_date)
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Discharge Date</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $visit->admission->discharge_date->format('M d, Y') }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
