<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Visit Billing & Checkout</h2>
                        <p class="text-gray-600 mt-1">Consolidate charges and process payments</p>
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <!-- Visits List -->
                    <div class="lg:col-span-1">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Visits Ready for Billing</h3>
                        <div class="space-y-3 max-h-[600px] overflow-y-auto">
                            @forelse($visits as $visit)
                                <div class="border border-gray-200 rounded-lg p-4 cursor-pointer hover:shadow-md transition-shadow {{ $selectedVisitId === $visit->id ? 'bg-blue-50 border-blue-300' : '' }}" 
                                     wire:click="selectVisit({{ $visit->id }})">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <h4 class="font-semibold text-gray-900">{{ $visit->patient->full_name }}</h4>
                                            <p class="text-sm text-gray-500">{{ $visit->visit_number }}</p>
                                        </div>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-{{ $visit->status_color }}-100 text-{{ $visit->status_color }}-800">
                                            {{ $visit->status_label }}
                                        </span>
                                    </div>
                                    <div class="text-xs text-gray-500">
                                        {{ $visit->checked_in_at->format('M d, Y h:i A') }}
                                    </div>
                                    @if($visit->bills->count() > 0)
                                        @php
                                            $bill = $visit->bills->first();
                                        @endphp
                                        <div class="mt-2 text-xs">
                                            <span class="font-medium">Bill:</span> 
                                            <span class="{{ $bill->status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                                                ₦{{ number_format($bill->total_amount, 2) }} 
                                                ({{ ucfirst($bill->status) }})
                                            </span>
                                        </div>
                                    @endif
                                </div>
                            @empty
                                <p class="text-sm text-gray-500 text-center py-8">No visits ready for billing.</p>
                            @endforelse
                        </div>
                        <div class="mt-4">
                            {{ $visits->links() }}
                        </div>
                    </div>

                    <!-- Bill Details -->
                    <div class="lg:col-span-2">
                        @if($selectedVisit)
                            <div class="bg-white border border-gray-200 rounded-lg p-6">
                                <div class="flex justify-between items-center mb-4">
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900">Bill for {{ $selectedVisit->patient->full_name }}</h3>
                                        <p class="text-sm text-gray-500">Visit: {{ $selectedVisit->visit_number }}</p>
                                    </div>
                                    @if($selectedBill && $selectedBill->status === 'paid')
                                        <span class="px-3 py-1 text-sm font-semibold rounded-full bg-green-100 text-green-800">
                                            Paid
                                        </span>
                                    @endif
                                </div>

                                @if(!$selectedBill)
                                    <!-- Calculate and Create Bill -->
                                    <div class="mb-6">
                                        <button wire:click="calculateBill" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded text-sm mb-4">
                                            Calculate Bill
                                        </button>

                                        @if(count($billItems) > 0)
                                            <div class="border border-gray-200 rounded-lg p-4 mb-4">
                                                <h4 class="font-semibold text-gray-900 mb-3">Bill Breakdown</h4>
                                                <table class="min-w-full">
                                                    <thead class="bg-gray-50">
                                                        <tr>
                                                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Description</th>
                                                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">Qty</th>
                                                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">Unit Price</th>
                                                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="divide-y divide-gray-200">
                                                        @foreach($billItems as $item)
                                                            <tr>
                                                                <td class="px-4 py-2 text-sm text-gray-900">{{ $item['description'] }}</td>
                                                                <td class="px-4 py-2 text-sm text-gray-500 text-right">{{ $item['quantity'] }}</td>
                                                                <td class="px-4 py-2 text-sm text-gray-500 text-right">₦{{ number_format($item['unit_price'], 2) }}</td>
                                                                <td class="px-4 py-2 text-sm font-medium text-gray-900 text-right">₦{{ number_format($item['total'], 2) }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>

                                                <div class="mt-4 space-y-2 text-sm">
                                                    <div class="flex justify-between">
                                                        <span class="text-gray-600">Subtotal:</span>
                                                        <span class="font-medium">₦{{ number_format($subtotal, 2) }}</span>
                                                    </div>
                                                    <div class="flex justify-between">
                                                        <span class="text-gray-600">Tax (5%):</span>
                                                        <span class="font-medium">₦{{ number_format($tax_amount, 2) }}</span>
                                                    </div>
                                                    <div class="flex justify-between">
                                                        <label class="text-gray-600">
                                                            <input type="number" wire:model.live="discount_amount" step="0.01" min="0" class="w-24 border-gray-300 rounded text-right" placeholder="0.00">
                                                            Discount:
                                                        </label>
                                                        <span class="font-medium">-₦{{ number_format($discount_amount, 2) }}</span>
                                                    </div>
                                                    <div class="flex justify-between pt-2 border-t border-gray-200">
                                                        <span class="font-semibold text-gray-900">Total:</span>
                                                        <span class="font-bold text-lg text-gray-900">₦{{ number_format($total_amount, 2) }}</span>
                                                    </div>
                                                </div>

                                                <div class="mt-4">
                                                    <label class="flex items-center">
                                                        <input type="checkbox" wire:model.live="insurance_covered" class="rounded border-gray-300 text-blue-600">
                                                        <span class="ml-2 text-sm text-gray-700">Insurance Covered</span>
                                                    </label>
                                                    @if($insurance_covered)
                                                        <div class="mt-2 text-sm text-gray-600">
                                                            Patient Responsibility (20%): ₦{{ number_format($patient_responsibility, 2) }}
                                                        </div>
                                                    @endif
                                                </div>

                                                <button wire:click="createBill" class="mt-4 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded">
                                                    Create Bill
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                @else
                                    <!-- Existing Bill -->
                                    <div class="border border-gray-200 rounded-lg p-4 mb-4">
                                        <div class="flex justify-between items-center mb-4">
                                            <div>
                                                <h4 class="font-semibold text-gray-900">Bill #{{ $selectedBill->bill_number }}</h4>
                                                <p class="text-sm text-gray-500">Created: {{ $selectedBill->created_at->format('M d, Y h:i A') }}</p>
                                            </div>
                                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-{{ $selectedBill->status_badge_color }}-100 text-{{ $selectedBill->status_badge_color }}-800">
                                                {{ ucfirst($selectedBill->status) }}
                                            </span>
                                        </div>

                                        <div class="space-y-2 text-sm mb-4">
                                            <div class="flex justify-between">
                                                <span class="text-gray-600">Subtotal:</span>
                                                <span class="font-medium">₦{{ number_format($selectedBill->subtotal, 2) }}</span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-gray-600">Tax:</span>
                                                <span class="font-medium">₦{{ number_format($selectedBill->tax_amount, 2) }}</span>
                                            </div>
                                            @if($selectedBill->discount_amount > 0)
                                                <div class="flex justify-between">
                                                    <span class="text-gray-600">Discount:</span>
                                                    <span class="font-medium">-₦{{ number_format($selectedBill->discount_amount, 2) }}</span>
                                                </div>
                                            @endif
                                            <div class="flex justify-between pt-2 border-t border-gray-200">
                                                <span class="font-semibold text-gray-900">Total Amount:</span>
                                                <span class="font-bold text-lg text-gray-900">₦{{ number_format($selectedBill->total_amount, 2) }}</span>
                                            </div>
                                            <div class="flex justify-between pt-2 border-t border-gray-200">
                                                <span class="font-semibold text-gray-900">Balance:</span>
                                                <span class="font-bold text-lg {{ $selectedBill->balance > 0 ? 'text-red-600' : 'text-green-600' }}">
                                                    ₦{{ number_format($selectedBill->balance, 2) }}
                                                </span>
                                            </div>
                                        </div>

                                        @if($selectedBill->payments->count() > 0)
                                            <div class="mt-4">
                                                <h5 class="font-semibold text-sm text-gray-900 mb-2">Payment History</h5>
                                                <div class="space-y-2">
                                                    @foreach($selectedBill->payments as $payment)
                                                        <div class="flex justify-between text-sm bg-gray-50 p-2 rounded">
                                                            <span>₦{{ number_format($payment->amount, 2) }} - {{ ucfirst($payment->payment_method) }}</span>
                                                            <span class="text-gray-500">{{ $payment->payment_date->format('M d, Y') }}</span>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif

                                        @if($selectedBill->balance > 0)
                                            <button wire:click="openPaymentModal" class="mt-4 w-full bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                                                Process Payment
                                            </button>
                                        @else
                                            <button wire:click="checkout" wire:confirm="Are you sure you want to check out this patient?" class="mt-4 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded">
                                                Check Out Patient
                                            </button>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        @else
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-12 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <h3 class="mt-2 text-sm font-medium text-gray-900">Select a visit</h3>
                                <p class="mt-1 text-sm text-gray-500">Choose a visit from the list to view and process billing.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    @if($showPaymentModal && $selectedBill)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closePaymentModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                Process Payment
                            </h3>
                            <button wire:click="closePaymentModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="processPayment" class="space-y-4">
                            <div>
                                <x-input-label for="payment_amount" :value="__('Payment Amount *')" />
                                <x-text-input id="payment_amount" class="block mt-1 w-full" type="number" step="0.01" wire:model="payment_amount" min="0.01" max="{{ $selectedBill->balance }}" required />
                                <p class="mt-1 text-xs text-gray-500">Balance: ₦{{ number_format($selectedBill->balance, 2) }}</p>
                                <x-input-error :messages="$errors->get('payment_amount')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="payment_method" :value="__('Payment Method *')" />
                                <select id="payment_method" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="payment_method" required>
                                    <option value="cash">Cash</option>
                                    <option value="card">Card</option>
                                    <option value="hmo">HMO/Insurance</option>
                                    <option value="other">Other</option>
                                </select>
                                <x-input-error :messages="$errors->get('payment_method')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="payment_reference" :value="__('Reference Number (Optional)')" />
                                <x-text-input id="payment_reference" class="block mt-1 w-full" type="text" wire:model="payment_reference" />
                                <x-input-error :messages="$errors->get('payment_reference')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="payment_notes" :value="__('Notes (Optional)')" />
                                <textarea id="payment_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="payment_notes"></textarea>
                                <x-input-error :messages="$errors->get('payment_notes')" class="mt-1" />
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closePaymentModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="processPayment" class="text-sm">
                                    <span wire:loading.remove wire:target="processPayment">Process Payment</span>
                                    <span wire:loading wire:target="processPayment">Processing...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
