<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <!-- Header -->
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Drug Management</h2>
                        <p class="text-gray-600 mt-1">Manage drug catalog and information</p>
                    </div>
                    <div class="flex gap-2">
                        <button wire:click="openCategoryModal" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded">
                            + Add Category
                        </button>
                        <button wire:click="openBulkUploadModal" class="bg-purple-500 hover:bg-purple-600 text-white font-bold py-2 px-4 rounded">
                            📤 Bulk Upload
                        </button>
                        <button wire:click="openCreateModal" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                            + Add New Drug
                        </button>
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                @if (session()->has('bulk_upload_errors'))
                    <div class="mb-4 p-4 bg-yellow-100 border border-yellow-400 text-yellow-700 rounded">
                        <p class="font-bold">Upload Errors:</p>
                        <ul class="list-disc list-inside mt-2">
                            @foreach(session('bulk_upload_errors') as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Filters -->
                <div class="mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                        <input type="text" wire:model.live.debounce.300ms="search" 
                               placeholder="Search by name, generic name, manufacturer..."
                               class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                        <select wire:model.live="categoryFilter" 
                                class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">All Categories</option>
                            @foreach($drugCategories as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select wire:model.live="statusFilter" 
                                class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">All Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>

                <!-- Drugs Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dosage Form</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Strength</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price (₦)</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Qty</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($drugs as $drug)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $drug->name }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $drug->dosage_form }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $drug->strength }} {{ $drug->unit }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        @php
                                            $latestStock = $drug->pharmacyStocks
                                                ->where('quantity', '>', 0)
                                                ->whereNotNull('unit_price')
                                                ->sortByDesc('created_at')
                                                ->first();
                                        @endphp
                                        @if($latestStock && $latestStock->unit_price)
                                            {{ number_format($latestStock->unit_price, 2) }}
                                        @else
                                            <span class="text-gray-400">-</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        @php
                                            $totalQuantity = $drug->pharmacyStocks->sum('quantity') ?? 0;
                                            $availableQuantity = $drug->pharmacyStocks->filter(function($stock) {
                                                return !$stock->expiry_date || $stock->expiry_date->isFuture();
                                            })->sum('quantity') ?? 0;
                                        @endphp
                                        @if($totalQuantity > 0)
                                            <span class="font-medium {{ $availableQuantity <= 10 ? 'text-red-600' : ($availableQuantity <= 50 ? 'text-yellow-600' : 'text-green-600') }}">
                                                {{ number_format($availableQuantity) }}
                                            </span>
                                            @if($totalQuantity != $availableQuantity)
                                                <span class="text-gray-400 text-xs">({{ number_format($totalQuantity) }} total)</span>
                                            @endif
                                            <span class="text-gray-400 text-xs block">units</span>
                                        @else
                                            <span class="text-gray-400">No stock</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $drug->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ $drug->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex justify-end space-x-2">
                                            <a href="{{ route('drugs.show', $drug->id) }}" 
                                               class="text-purple-600 hover:text-purple-900">View</a>
                                            <button wire:click="toggleStatus({{ $drug->id }})" 
                                                    class="text-{{ $drug->is_active ? 'yellow' : 'green' }}-600 hover:text-{{ $drug->is_active ? 'yellow' : 'green' }}-900">
                                                {{ $drug->is_active ? 'Deactivate' : 'Activate' }}
                                            </button>
                                            <button wire:click="openEditModal({{ $drug->id }})" 
                                                    class="text-blue-600 hover:text-blue-900">Edit</button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No drugs found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $drugs->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    @if($showModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white max-h-[85vh] overflow-y-auto" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">
                        {{ $editingDrug ? 'Edit Drug' : 'Create New Drug' }}
                    </h3>
                    <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Name -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Name <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="name" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Generic Name -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Generic Name <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="generic_name" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('generic_name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Manufacturer -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Manufacturer <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="manufacturer" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('manufacturer') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Category -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Category <span class="text-red-500">*</span></label>
                            <select wire:model="category_id" 
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select Category</option>
                                @foreach($drugCategories as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                            @error('category_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            @error('category') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Dosage Form -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Dosage Form <span class="text-red-500">*</span></label>
                            <select wire:model="dosage_form" 
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select Dosage Form</option>
                                @foreach($dosageForms as $form)
                                    <option value="{{ $form }}">{{ $form }}</option>
                                @endforeach
                            </select>
                            @error('dosage_form') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Strength -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Strength <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="strength" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                   placeholder="e.g., 500mg, 100 units/mL">
                            @error('strength') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Unit -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Unit <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="unit" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                   placeholder="e.g., mg, ml, units">
                            @error('unit') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Expiry Alert Days -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Expiry Alert Days</label>
                            <input type="number" wire:model="expiry_alert_days" min="0" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('expiry_alert_days') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Prescription Required -->
                        <div class="md:col-span-2">
                            <label class="flex items-center">
                                <input type="checkbox" wire:model="prescription_required" 
                                       class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <span class="ml-2 text-sm text-gray-700">Prescription Required</span>
                            </label>
                        </div>

                        <!-- Is Active -->
                        <div class="md:col-span-2">
                            <label class="flex items-center">
                                <input type="checkbox" wire:model="is_active" 
                                       class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <span class="ml-2 text-sm text-gray-700">Active</span>
                            </label>
                        </div>

                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea wire:model="description" rows="3" 
                                      class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                      placeholder="Drug description..."></textarea>
                            @error('description') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Storage Conditions -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Storage Conditions</label>
                            <textarea wire:model="storage_conditions" rows="2" 
                                      class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                      placeholder="e.g., Store at room temperature, Refrigerate"></textarea>
                            @error('storage_conditions') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Side Effects -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Side Effects</label>
                            <div class="flex gap-2 mb-2">
                                <input type="text" wire:model="side_effect_input" 
                                       wire:keydown.enter.prevent="addSideEffect"
                                       class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="Add side effect and press Enter">
                                <button type="button" wire:click="addSideEffect" 
                                        class="px-4 py-2 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                                    Add
                                </button>
                            </div>
                            <div class="flex flex-wrap gap-2">
                                @foreach($side_effects as $index => $effect)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                        {{ $effect }}
                                        <button type="button" wire:click="removeSideEffect({{ $index }})" class="ml-2 text-red-600 hover:text-red-800">×</button>
                                    </span>
                                @endforeach
                            </div>
                        </div>

                        <!-- Contraindications -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Contraindications</label>
                            <div class="flex gap-2 mb-2">
                                <input type="text" wire:model="contraindication_input" 
                                       wire:keydown.enter.prevent="addContraindication"
                                       class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="Add contraindication and press Enter">
                                <button type="button" wire:click="addContraindication" 
                                        class="px-4 py-2 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                                    Add
                                </button>
                            </div>
                            <div class="flex flex-wrap gap-2">
                                @foreach($contraindications as $index => $contra)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800">
                                        {{ $contra }}
                                        <button type="button" wire:click="removeContraindication({{ $index }})" class="ml-2 text-orange-600 hover:text-orange-800">×</button>
                                    </span>
                                @endforeach
                            </div>
                        </div>

                        <!-- Interactions -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Drug Interactions</label>
                            <div class="flex gap-2 mb-2">
                                <input type="text" wire:model="interaction_input" 
                                       wire:keydown.enter.prevent="addInteraction"
                                       class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="Add interaction and press Enter">
                                <button type="button" wire:click="addInteraction" 
                                        class="px-4 py-2 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                                    Add
                                </button>
                            </div>
                            <div class="flex flex-wrap gap-2">
                                @foreach($interactions as $index => $interaction)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                        {{ $interaction }}
                                        <button type="button" wire:click="removeInteraction({{ $index }})" class="ml-2 text-yellow-600 hover:text-yellow-800">×</button>
                                    </span>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <button type="button" wire:click="closeModal" 
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                            {{ $editingDrug ? 'Update Drug' : 'Create Drug' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Category Creation Modal -->
    @if($showCategoryModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeCategoryModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-1/2 lg:w-1/3 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Add New Category</h3>
                    <button wire:click="closeCategoryModal" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <form wire:submit.prevent="saveCategory">
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Category Name <span class="text-red-500">*</span></label>
                            <input type="text" wire:model="category_name" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                                   placeholder="e.g., Antibiotic, Pain Reliever">
                            @error('category_name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea wire:model="category_description" rows="3" 
                                      class="block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500"
                                      placeholder="Category description (optional)"></textarea>
                            @error('category_description') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <button type="button" wire:click="closeCategoryModal" 
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-green-500 text-white rounded hover:bg-green-600">
                            Create Category
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Bulk Upload Modal -->
    @if($showBulkUploadModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeBulkUploadModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Bulk Upload Drugs</h3>
                    <button wire:click="closeBulkUploadModal" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded">
                    <h4 class="font-semibold text-blue-900 mb-2">CSV Format Requirements:</h4>
                    <p class="text-sm text-blue-800 mb-2">Upload a CSV file with the following columns (header row optional):</p>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="font-semibold text-blue-900 mb-1">Required Drug Fields:</p>
                            <ul class="text-sm text-blue-800 list-disc list-inside space-y-1">
                                <li><strong>name</strong> - Drug name</li>
                                <li><strong>generic_name</strong> - Generic name</li>
                                <li><strong>manufacturer</strong> - Manufacturer name</li>
                                <li><strong>category</strong> - Category (auto-created if missing)</li>
                                <li><strong>dosage_form</strong> - e.g., Tablet, Capsule</li>
                                <li><strong>strength</strong> - e.g., 500mg</li>
                                <li><strong>unit</strong> - e.g., mg, ml</li>
                            </ul>
                        </div>
                        <div>
                            <p class="font-semibold text-blue-900 mb-1">Optional Fields:</p>
                            <ul class="text-sm text-blue-800 list-disc list-inside space-y-1">
                                <li><strong>description</strong> - Drug description</li>
                                <li><strong>prescription_required</strong> - true/false (default: true)</li>
                                <li><strong>is_active</strong> - true/false (default: true)</li>
                            </ul>
                            <p class="font-semibold text-green-900 mt-2 mb-1">Inventory Fields (Optional):</p>
                            <ul class="text-sm text-green-800 list-disc list-inside space-y-1">
                                <li><strong>quantity</strong> - Stock quantity</li>
                                <li><strong>reorder_level</strong> - Reorder level (default: 10)</li>
                                <li><strong>unit_price</strong> - Unit price</li>
                                <li><strong>expiry_date</strong> - YYYY-MM-DD</li>
                                <li><strong>batch_number</strong> - Batch number</li>
                                <li><strong>supplier</strong> - Supplier name</li>
                                <li><strong>supply_date</strong> - YYYY-MM-DD (default: today)</li>
                                <li><strong>notes</strong> - Additional notes</li>
                            </ul>
                        </div>
                    </div>
                    <p class="text-xs text-blue-700 mt-3 font-semibold">Example (with inventory):</p>
                    <p class="text-xs text-blue-700">Panadol,paracetamol,GlaxoSmithKline,Pain Reliever,Tablet,500mg,mg,Common pain killer,true,true,100,10,50.00,2025-12-31,BATCH001,Supplier ABC,2024-01-15,Initial stock</p>
                    <p class="text-xs text-blue-700 mt-1">Example (drug only, no inventory):</p>
                    <p class="text-xs text-blue-700">Panadol,paracetamol,GlaxoSmithKline,Pain Reliever,Tablet,500mg,mg,Common pain killer,true,true</p>
                    <p class="text-xs text-green-700 mt-2 font-semibold">💡 Tip: If quantity is provided, inventory will be automatically created for the drug!</p>
                </div>

                <form wire:submit.prevent="processBulkUpload">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-1">CSV File <span class="text-red-500">*</span></label>
                        <input type="file" wire:model="bulk_upload_file" accept=".csv,.txt"
                               class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                        @error('bulk_upload_file') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        @if($bulk_upload_file)
                            <p class="mt-1 text-sm text-gray-600">Selected: {{ $bulk_upload_file->getClientOriginalName() }}</p>
                        @endif
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <button type="button" wire:click="closeBulkUploadModal" 
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-purple-500 text-white rounded hover:bg-purple-600">
                            Upload & Process
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>
