<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <!-- Header -->
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Medication Administration Log</h2>
                        <p class="text-gray-600 mt-1">
                            @if($admission ?? null)
                                Record and manage medication administrations for admitted patients
                            @else
                                Select an admission to record medication administrations
                            @endif
                        </p>
                    </div>
                    @if($admission ?? null)
                        <div class="flex items-center space-x-2">
                            <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Nurse: {{ auth()->user()->name }}</span>
                        </div>
                    @endif
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                @if($admission ?? null)
                    <!-- Admission Information -->
                    <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-400 rounded">
                        <div class="flex justify-between items-start">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">{{ $admission->patient->full_name }}</h3>
                                <div class="mt-2 space-y-1 text-sm text-gray-600">
                                    <div><strong>Admission #:</strong> {{ $admission->admission_number }}</div>
                                    <div><strong>Patient ID:</strong> {{ $admission->patient->patient_id }}</div>
                                    <div><strong>Ward:</strong> {{ $admission->display_ward ?? 'N/A' }}</div>
                                    @if($admission->room_number || $admission->bed_number)
                                        <div><strong>Room/Bed:</strong> 
                                            {{ $admission->room_number ? 'Room: ' . $admission->room_number : '' }}
                                            {{ $admission->room_number && $admission->bed_number ? ' / ' : '' }}
                                            {{ $admission->bed_number ? 'Bed: ' . $admission->bed_number : '' }}
                                        </div>
                                    @endif
                                    <div><strong>Admission Date:</strong> {{ $admission->admission_date->format('M d, Y h:i A') }}</div>
                                </div>
                            </div>
                            <a href="{{ route('medications.log') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                ← Back to Admissions
                            </a>
                        </div>
                    </div>

                    @if(!$admission->isActive())
                        <div class="mb-4 p-4 bg-yellow-50 border border-yellow-200 rounded">
                            <p class="text-sm text-yellow-800">
                                <strong>Note:</strong> This patient has been {{ $admission->status }}. Medication administration records are read-only.
                            </p>
                        </div>
                    @else
                        <!-- Add Medication Button -->
                        <div class="mb-6">
                            <button wire:click="openModal" class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-lg flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                                </svg>
                                Record Medication Administration
                            </button>
                        </div>

                        <!-- Active Prescriptions Section -->
                        @if(isset($prescriptions) && $prescriptions->count() > 0)
                            <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-400 rounded">
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Active Prescriptions</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                    @foreach($prescriptions as $prescription)
                                        <div class="bg-white p-3 rounded border border-green-200">
                                            <div class="flex justify-between items-start">
                                                <div class="flex-1">
                                                    <div class="font-medium text-gray-900">
                                                        {{ $prescription->drug->name ?? 'Unknown Drug' }}
                                                    </div>
                                                    <div class="text-sm text-gray-600 mt-1">
                                                        <div><strong>Dosage:</strong> {{ $prescription->dosage }}</div>
                                                        <div><strong>Frequency:</strong> {{ $prescription->frequency }}</div>
                                                        <div><strong>Prescribed by:</strong> {{ $prescription->doctor->name ?? 'N/A' }}</div>
                                                        <div><strong>Valid until:</strong> {{ $prescription->valid_until->format('M d, Y') }}</div>
                                                    </div>
                                                </div>
                                                <button 
                                                    wire:click="selectPrescription({{ $prescription->id }})"
                                                    class="ml-2 bg-green-600 hover:bg-green-700 text-white text-xs px-3 py-1 rounded whitespace-nowrap"
                                                >
                                                    Use This
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    @endif

                    <!-- Medication Administration Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Medication</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dosage</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Route</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Time Administered</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nurse</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Notes</th>
                                    @if($admission->isActive())
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($medicationAdministrations ?? [] as $administration)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            @if($administration->prescription)
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    RX{{ str_pad($administration->prescription->id, 6, '0', STR_PAD_LEFT) }}
                                                </span>
                                            @else
                                                <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            {{ $administration->medication_name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $administration->dosage }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $administration->route_display }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $administration->time_administered->format('M d, Y h:i A') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ ucwords(strtolower($administration->nurse->name)) }}
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-500">
                                            {{ $administration->notes ?? '-' }}
                                        </td>
                                        @if($admission->isActive())
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <button 
                                                    wire:click="delete({{ $administration->id }})"
                                                    wire:confirm="Are you sure you want to delete this medication administration record?"
                                                    class="text-red-600 hover:text-red-900">
                                                    Delete
                                                </button>
                                            </td>
                                        @endif
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="{{ $admission->isActive() ? '8' : '7' }}" class="px-6 py-4 text-center text-gray-500">
                                            No medication administrations recorded yet.
                                            @if($admission->isActive())
                                                Click "Record Medication Administration" to add one.
                                            @endif
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($medicationAdministrations) && $medicationAdministrations->hasPages())
                        <div class="mt-4">
                            {{ $medicationAdministrations->links() }}
                        </div>
                    @endif
                @else
                    <!-- Admission Selection List -->
                    <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-400 rounded">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-blue-700">
                                    <strong>Instructions:</strong> Select an active admission to record medication administrations for that patient.
                                </p>
                            </div>
                        </div>
                    </div>

                    @if($admissions->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission #</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ward</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Room/Bed</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission Date</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($admissions as $admission)
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                                {{ $admission->admission_number }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $admission->patient->full_name }}</div>
                                                <div class="text-sm text-gray-500">{{ $admission->patient->patient_id }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                {{ $admission->display_ward ?? 'N/A' }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                @if($admission->room_number || $admission->bed_number)
                                                    {{ $admission->room_number ? 'Room: ' . $admission->room_number : '' }}
                                                    {{ $admission->room_number && $admission->bed_number ? ' / ' : '' }}
                                                    {{ $admission->bed_number ? 'Bed: ' . $admission->bed_number : '' }}
                                                @else
                                                    <span class="text-gray-400">-</span>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                {{ $admission->admission_date->format('M d, Y h:i A') }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <a href="{{ route('medications.log') }}?admission={{ $admission->id }}" class="text-blue-600 hover:text-blue-900">
                                                    View/Record Medications
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-4">
                            {{ $admissions->links() }}
                        </div>
                    @else
                        <div class="text-center py-12 bg-gray-50 rounded-lg">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No active admissions</h3>
                            <p class="mt-1 text-sm text-gray-500">There are currently no admitted patients.</p>
                        </div>
                    @endif
                @endif
            </div>
        </div>
    </div>

    <!-- Medication Administration Modal -->
    @if($showModal ?? false)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Record Medication Administration
                                </h3>
                                @if($admission ?? null)
                                    <p class="text-sm text-gray-500 mt-1">
                                        {{ $admission->patient->full_name }} • {{ $admission->admission_number }}
                                    </p>
                                @endif
                            </div>
                            <button wire:click="closeModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="save" class="space-y-4">
                            @if($prescription_id)
                                <div class="p-3 bg-green-50 border border-green-200 rounded-lg mb-4">
                                    <div class="flex justify-between items-center">
                                        <div class="text-sm text-green-800">
                                            <strong>Using prescription:</strong> Medication details pre-filled from prescription.
                                        </div>
                                        <button type="button" wire:click="clearPrescription" class="text-green-700 hover:text-green-900 text-sm font-medium">
                                            Clear
                                        </button>
                                    </div>
                                </div>
                            @endif

                            <div>
                                <x-input-label for="medication_name" :value="__('Medication Name *')" />
                                <x-text-input id="medication_name" class="block mt-1 w-full" type="text" wire:model="medication_name" placeholder="e.g., Paracetamol, Amoxicillin" required />
                                <x-input-error :messages="$errors->get('medication_name')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="dosage" :value="__('Dosage *')" />
                                <x-text-input id="dosage" class="block mt-1 w-full" type="text" wire:model="dosage" placeholder="e.g., 500mg, 10ml" required />
                                <x-input-error :messages="$errors->get('dosage')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="route" :value="__('Route *')" />
                                <select id="route" wire:model="route" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" required>
                                    <option value="">Select Route</option>
                                    @foreach($availableRoutes ?? [] as $routeOption)
                                        <option value="{{ $routeOption }}">{{ $routeOption }}</option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('route')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="time_administered" :value="__('Time Administered *')" />
                                <x-text-input id="time_administered" class="block mt-1 w-full" type="datetime-local" wire:model="time_administered" required />
                                <x-input-error :messages="$errors->get('time_administered')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="notes" :value="__('Notes')" />
                                <textarea id="notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="notes" placeholder="Any additional notes about the medication administration..."></textarea>
                                <x-input-error :messages="$errors->get('notes')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> This record will be logged with your nurse ID and cannot be modified after creation. Only you or administrators can delete this record.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="save" class="text-sm">
                                    <span wire:loading.remove wire:target="save">Record Medication</span>
                                    <span wire:loading wire:target="save">Recording...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
