<div wire:poll.5s>
    <div class="space-y-4">
        <!-- Pending Visits for Nurses -->
        @if(auth()->user()->isNurse() && $pendingVisitsForNurse->count() > 0)
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Patients Waiting for Vitals</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-yellow-100 text-yellow-800 rounded-full">{{ $pendingVisitsForNurse->count() }}</span>
                </div>
                <div class="space-y-2">
                    @foreach($pendingVisitsForNurse->take(5) as $visit)
                        <a href="{{ route('nursing.vitals') }}" class="flex items-center justify-between p-2 bg-gray-50 rounded-lg hover:bg-yellow-50 transition-colors">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ ucwords(strtolower($visit->patient->full_name)) }}</p>
                                <p class="text-xs text-gray-500">{{ $visit->visit_number }} • {{ $visit->checked_in_at->diffForHumans() }}</p>
                            </div>
                            <span class="text-xs font-semibold text-yellow-600">→</span>
                        </a>
                    @endforeach
                </div>
                @if($pendingVisitsForNurse->count() > 5)
                    <a href="{{ route('nursing.vitals') }}" class="block text-center text-xs text-yellow-600 hover:text-yellow-700 font-medium py-2 mt-2">
                        +{{ $pendingVisitsForNurse->count() - 5 }} more →
                    </a>
                @endif
            </div>
        @endif

        <!-- Pending Visits for Doctors -->
        @if(auth()->user()->isDoctor() && $pendingVisitsForDoctor->count() > 0)
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Patients Waiting for Consultation</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-orange-100 text-orange-800 rounded-full">{{ $pendingVisitsForDoctor->count() }}</span>
                </div>
                <div class="space-y-2">
                    @foreach($pendingVisitsForDoctor->take(5) as $visit)
                        <a href="{{ route('doctor.consultations') }}" class="flex items-center justify-between p-2 bg-gray-50 rounded-lg hover:bg-orange-50 transition-colors">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ ucwords(strtolower($visit->patient->full_name)) }}</p>
                                <p class="text-xs text-gray-500">{{ $visit->visit_number }} • {{ $visit->checked_in_at->diffForHumans() }}</p>
                            </div>
                            <span class="text-xs font-semibold text-orange-600">→</span>
                        </a>
                    @endforeach
                </div>
                @if($pendingVisitsForDoctor->count() > 5)
                    <a href="{{ route('doctor.consultations') }}" class="block text-center text-xs text-orange-600 hover:text-orange-700 font-medium py-2 mt-2">
                        +{{ $pendingVisitsForDoctor->count() - 5 }} more →
                    </a>
                @endif
            </div>
        @endif
        
        <!-- Pending Bills -->
        @if(!auth()->user()->isNurse() && !auth()->user()->isDoctor() && $pendingBills->count() > 0)
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Pending Bills</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-amber-100 text-amber-800 rounded-full">{{ $pendingBills->count() }}</span>
                </div>
                <div class="space-y-2">
                    @foreach($pendingBills->take(3) as $bill)
                        <div class="flex items-center justify-between p-2 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ ucwords(strtolower($bill->patient->full_name)) }}</p>
                                <p class="text-xs text-gray-500">{{ $bill->bill_number }}</p>
                            </div>
                            <span class="text-sm font-semibold text-amber-600">{{ config('app.currency_symbol') }}{{ number_format($bill->total_amount, 2) }}</span>
                        </div>
                    @endforeach
                </div>
                @if($pendingBills->count() > 3)
                    <a href="{{ route('bills.index') }}" class="block text-center text-xs text-amber-600 hover:text-amber-700 font-medium py-2 mt-2">
                        +{{ $pendingBills->count() - 3 }} more →
                    </a>
                @endif
            </div>
        @endif

        <!-- Upcoming Appointments to Confirm -->
        @if(!auth()->user()->isNurse() && !auth()->user()->isDoctor() && $pendingAppointments->count() > 0)
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h4 class="text-sm font-semibold text-gray-700">Appointments to Confirm</h4>
                    <span class="px-2 py-1 text-xs font-semibold bg-blue-100 text-blue-800 rounded-full">{{ $pendingAppointments->count() }}</span>
                </div>
                <div class="space-y-2">
                    @foreach($pendingAppointments as $appointment)
                        <div class="flex items-center justify-between p-2 bg-gray-50 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ ucwords(strtolower($appointment->patient_name)) }}</p>
                                <p class="text-xs text-gray-500">{{ $appointment->appointment_date->format('M d') }} at {{ \Carbon\Carbon::parse($appointment->appointment_time)->format('h:i A') }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        @if($totalPending === 0 && $pendingAppointments->count() === 0 && $pendingVisitsForNurse->count() === 0 && $pendingVisitsForDoctor->count() === 0)
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="mt-2 text-sm font-medium text-gray-900">All caught up!</p>
                <p class="mt-1 text-sm text-gray-500">No pending tasks at this time.</p>
            </div>
        @endif
    </div>
</div>
