<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Doctor Consultation</h2>
                        <p class="text-gray-600 mt-1">Review patient information and conduct consultations</p>
                    </div>
                    <div class="flex items-center space-x-2">
                        <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <span class="text-sm text-gray-600">Dr. {{ auth()->user()->name }}</span>
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Info Banner -->
                <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-400 rounded">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-blue-700">
                                <strong>Instructions:</strong> Select a patient visit to review vitals recorded by nursing staff, view medical history, and conduct consultation. All information is linked to the visit record.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Visits Waiting for Doctor -->
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Patients Waiting for Doctor</h3>
                    
                    @if($visits->count() > 0)
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($visits as $visit)
                                <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow cursor-pointer" wire:click="selectVisit({{ $visit->id }})">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <h4 class="font-semibold text-gray-900">{{ $visit->patient->full_name }}</h4>
                                            <p class="text-sm text-gray-500">{{ $visit->patient->patient_id }}</p>
                                        </div>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-orange-100 text-orange-800">
                                            {{ $visit->status_label }}
                                        </span>
                                    </div>
                                    <div class="mt-3 space-y-1 text-sm text-gray-600">
                                        <div class="flex items-center">
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                            Checked in: {{ $visit->checked_in_at->format('h:i A') }}
                                        </div>
                                        @if($visit->chief_complaint)
                                            <div class="flex items-start mt-2">
                                                <svg class="w-4 h-4 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                </svg>
                                                <span class="text-xs">{{ strlen($visit->chief_complaint) > 60 ? substr($visit->chief_complaint, 0, 60) . '...' : $visit->chief_complaint }}</span>
                                            </div>
                                        @endif
                                        @php
                                            $hasVitals = $visit->medicalRecords->where('visit_id', $visit->id)->first()?->vital_signs;
                                        @endphp
                                        @if($hasVitals)
                                            <div class="mt-2 text-xs text-green-600 font-medium">
                                                ✓ Vitals recorded
                                            </div>
                                        @endif
                                    </div>
                                    <div class="mt-3 pt-3 border-t border-gray-200">
                                        <button class="w-full bg-blue-500 hover:bg-blue-600 text-white text-sm font-medium py-2 px-4 rounded">
                                            Start Consultation
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12 bg-gray-50 rounded-lg">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No patients waiting</h3>
                            <p class="mt-1 text-sm text-gray-500">All patients have been seen or are waiting for other departments.</p>
                        </div>
                    @endif
                </div>

                <!-- Pagination -->
                @if($visits->hasPages())
                    <div class="mt-4">
                        {{ $visits->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Consultation Modal -->
    @if($showConsultationModal && $selectedVisit && $selectedPatient)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true" style="z-index: 9999;">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeConsultationModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel - Large for consultation form -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-5xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4 max-h-[90vh] overflow-y-auto">
                        <div class="flex justify-between items-center mb-4 sticky top-0 bg-white pb-2 border-b">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Consultation - {{ $selectedPatient->full_name }}
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    Visit: {{ $selectedVisit->visit_number }} • Patient ID: {{ $selectedPatient->patient_id }}
                                </p>
                            </div>
                            <button wire:click="closeConsultationModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="saveConsultation" class="space-y-6">
                            <!-- Patient Information & Vitals Section -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Patient Info -->
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <h4 class="font-semibold text-gray-900 mb-3">Patient Information</h4>
                                    <div class="space-y-2 text-sm">
                                        <div><strong>Name:</strong> {{ $selectedPatient->full_name }}</div>
                                        <div><strong>Age:</strong> {{ $selectedPatient->age }} years</div>
                                        <div><strong>Gender:</strong> {{ ucfirst($selectedPatient->gender) }}</div>
                                        @if($selectedPatient->allergies)
                                            <div class="mt-2 p-2 bg-red-50 border border-red-200 rounded">
                                                <strong class="text-red-800">⚠ Allergies:</strong>
                                                <p class="text-red-700 text-xs mt-1">{{ $selectedPatient->allergies }}</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- Vitals Recorded by Nurse -->
                                <div class="bg-blue-50 p-4 rounded-lg">
                                    <h4 class="font-semibold text-gray-900 mb-3">Vital Signs (Recorded by Nurse)</h4>
                                    @if($vitalsRecord && $vitalsRecord->vital_signs)
                                        <div class="grid grid-cols-2 gap-2 text-sm">
                                            @if(isset($vitalsRecord->vital_signs['blood_pressure']))
                                                <div><strong>BP:</strong> {{ $vitalsRecord->vital_signs['blood_pressure'] }}</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['temperature']))
                                                <div><strong>Temp:</strong> {{ $vitalsRecord->vital_signs['temperature'] }}°F</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['pulse']))
                                                <div><strong>Pulse:</strong> {{ $vitalsRecord->vital_signs['pulse'] }} BPM</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['height']))
                                                <div><strong>Height:</strong> {{ $vitalsRecord->vital_signs['height'] }} cm</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['weight']))
                                                <div><strong>Weight:</strong> {{ $vitalsRecord->vital_signs['weight'] }} kg</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['respiratory_rate']))
                                                <div><strong>RR:</strong> {{ $vitalsRecord->vital_signs['respiratory_rate'] }}</div>
                                            @endif
                                            @if(isset($vitalsRecord->vital_signs['oxygen_saturation']))
                                                <div><strong>SpO2:</strong> {{ $vitalsRecord->vital_signs['oxygen_saturation'] }}%</div>
                                            @endif
                                        </div>
                                    @else
                                        <p class="text-sm text-gray-500">No vitals recorded yet</p>
                                    @endif
                                </div>
                            </div>

                            <!-- Medical History -->
                            @if($selectedPatient->medical_history)
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <h4 class="font-semibold text-gray-900 mb-2">Medical History</h4>
                                    <p class="text-sm text-gray-700 whitespace-pre-line">{{ $selectedPatient->medical_history }}</p>
                                </div>
                            @endif

                            <!-- Past Consultations Section -->
                            <div class="border-t border-gray-200 pt-4 mb-4">
                                <div class="flex justify-between items-center mb-3">
                                    <h4 class="text-md font-semibold text-gray-900">Past Consultations{{ $this->pastConsultations->count() > 0 ? ' (' . $this->pastConsultations->count() . ')' : '' }}</h4>
                                </div>
                                @if($this->pastConsultations->count() > 0)
                                    <div class="space-y-3 max-h-64 overflow-y-auto">
                                        @foreach($this->pastConsultations as $pastConsultation)
                                            <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                                                <div class="flex justify-between items-start mb-2">
                                                    <div>
                                                        <div class="flex items-center gap-2">
                                                            <span class="text-sm font-semibold text-gray-900">
                                                                {{ ucfirst(str_replace('_', ' ', $pastConsultation->consultation_type)) }}
                                                            </span>
                                                            <span class="px-2 py-0.5 text-xs font-semibold rounded-full bg-{{ $pastConsultation->status_badge_color }}-100 text-{{ $pastConsultation->status_badge_color }}-800">
                                                                {{ ucfirst($pastConsultation->status) }}
                                                            </span>
                                                        </div>
                                                        <div class="text-xs text-gray-500 mt-1">
                                                            {{ $pastConsultation->consultation_date->format('M d, Y') }} 
                                                            @if($pastConsultation->consultation_time)
                                                                • {{ $pastConsultation->consultation_time->format('h:i A') }}
                                                            @endif
                                                            @if($pastConsultation->doctor)
                                                                • Dr. {{ ucwords(strtolower($pastConsultation->doctor->name)) }}
                                                            @endif
                                                            @if($pastConsultation->visit)
                                                                • Visit: {{ $pastConsultation->visit->visit_number }}
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                @if($pastConsultation->chief_complaint)
                                                    <div class="mt-2">
                                                        <div class="text-xs font-medium text-gray-700">Chief Complaint:</div>
                                                        <div class="text-xs text-gray-600 mt-1">{{ $pastConsultation->chief_complaint }}</div>
                                                    </div>
                                                @endif
                                                
                                                @if($pastConsultation->diagnosis)
                                                    <div class="mt-2">
                                                        <div class="text-xs font-medium text-gray-700">Diagnosis:</div>
                                                        <div class="text-xs text-gray-600 mt-1">{{ $pastConsultation->diagnosis }}</div>
                                                    </div>
                                                @endif
                                                
                                                @if($pastConsultation->treatment_plan)
                                                    <div class="mt-2">
                                                        <div class="text-xs font-medium text-gray-700">Treatment Plan:</div>
                                                        <div class="text-xs text-gray-600 mt-1">{{ strlen($pastConsultation->treatment_plan) > 150 ? substr($pastConsultation->treatment_plan, 0, 150) . '...' : $pastConsultation->treatment_plan }}</div>
                                                    </div>
                                                @endif
                                                
                                                @if($pastConsultation->physical_examination)
                                                    <div class="mt-2">
                                                        <div class="text-xs font-medium text-gray-700">Physical Examination:</div>
                                                        <div class="text-xs text-gray-600 mt-1">{{ strlen($pastConsultation->physical_examination) > 100 ? substr($pastConsultation->physical_examination, 0, 100) . '...' : $pastConsultation->physical_examination }}</div>
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-sm text-gray-500">No past consultations found for this patient.</p>
                                @endif
                            </div>

                            <!-- Lab Requests Section -->
                            @if($this->labRequests->count() > 0)
                                <div class="border-t border-gray-200 pt-4 mb-4">
                                    <div class="flex justify-between items-center mb-3">
                                        <h4 class="text-md font-semibold text-gray-900">Lab Requests</h4>
                                        <button type="button" wire:click.stop="openLabRequestModal" class="text-sm text-blue-600 hover:text-blue-800">
                                            + Request Lab Test
                                        </button>
                                    </div>
                                    <div class="space-y-2">
                                        @foreach($this->labRequests as $labRequest)
                                            <div class="p-3 bg-gray-50 rounded-lg border border-gray-200">
                                                <div class="flex justify-between items-start">
                                                    <div>
                                                        <div class="font-medium text-sm">{{ $labRequest->test_name }}</div>
                                                        <div class="text-xs text-gray-500 mt-1">{{ ucfirst(str_replace('_', ' ', $labRequest->test_type)) }}</div>
                                                        @if($labRequest->clinical_indication)
                                                            <div class="text-xs text-gray-600 mt-1">{{ $labRequest->clinical_indication }}</div>
                                                        @endif
                                                    </div>
                                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-{{ $labRequest->status_color }}-100 text-{{ $labRequest->status_color }}-800">
                                                        {{ ucfirst(str_replace('_', ' ', $labRequest->status)) }}
                                                    </span>
                                                </div>
                                        @if($labRequest->status === 'completed' && $labRequest->results)
                                            <div class="mt-2 pt-2 border-t border-gray-200">
                                                <div class="text-xs font-medium text-gray-700">Results:</div>
                                                <div class="text-xs text-gray-600 mt-1">{{ strlen($labRequest->results) > 100 ? substr($labRequest->results, 0, 100) . '...' : $labRequest->results }}</div>
                                            </div>
                                        @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                <div class="border-t border-gray-200 pt-4 mb-4">
                                    <div class="flex justify-between items-center">
                                        <h4 class="text-md font-semibold text-gray-900">Lab Requests</h4>
                                        <button type="button" wire:click.stop="openLabRequestModal" class="text-sm text-blue-600 hover:text-blue-800">
                                            + Request Lab Test
                                        </button>
                                    </div>
                                    <p class="text-sm text-gray-500 mt-2">No lab requests for this visit.</p>
                                </div>
                            @endif

                            <!-- Prescriptions Section -->
                            @if($this->prescriptions->count() > 0)
                                <div class="border-t border-gray-200 pt-4 mb-4">
                                    <div class="flex justify-between items-center mb-3">
                                        <h4 class="text-md font-semibold text-gray-900">Prescriptions ({{ $this->prescriptions->count() }})</h4>
                                        <button wire:click.stop="openPrescriptionModal" type="button" class="text-sm text-green-600 hover:text-green-800 font-medium">
                                            + Prescribe Medication
                                        </button>
                                    </div>
                                    <div class="space-y-2">
                                        @foreach($this->prescriptions as $prescription)
                                            <div class="p-3 bg-green-50 rounded-lg border border-green-200">
                                                <div class="flex justify-between items-start">
                                                    <div class="flex-1">
                                                        <div class="flex items-center gap-2">
                                                            <div class="font-medium text-sm text-gray-900">{{ ucwords(strtolower($prescription->drug->name)) }}</div>
                                                            <span class="px-2 py-0.5 text-xs font-semibold rounded-full bg-{{ $prescription->status_badge_color }}-100 text-{{ $prescription->status_badge_color }}-800">
                                                                {{ ucfirst($prescription->status) }}
                                                            </span>
                                                        </div>
                                                        <div class="text-xs text-gray-600 mt-1">{{ ucwords(strtolower($prescription->drug->generic_name)) }}</div>
                                                        <div class="grid grid-cols-2 md:grid-cols-4 gap-2 mt-2 text-xs text-gray-700">
                                                            <div><strong>Dosage:</strong> {{ $prescription->dosage }}</div>
                                                            <div><strong>Frequency:</strong> {{ $prescription->frequency }}</div>
                                                            <div><strong>Quantity:</strong> {{ $prescription->quantity }}</div>
                                                            <div><strong>Duration:</strong> {{ $prescription->duration }} days</div>
                                                        </div>
                                                        @if($prescription->instructions)
                                                            <div class="mt-2 text-xs text-gray-600">
                                                                <strong>Instructions:</strong> {{ $prescription->instructions }}
                                                            </div>
                                                        @endif
                                                        <div class="mt-1 text-xs text-gray-500">
                                                            Prescription #: {{ $prescription->prescription_number }} • 
                                                            Valid until: {{ $prescription->valid_until->format('M d, Y') }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                <div class="border-t border-gray-200 pt-4 mb-4">
                                    <div class="flex justify-between items-center">
                                        <h4 class="text-md font-semibold text-gray-900">Prescriptions</h4>
                                        <button wire:click.stop="openPrescriptionModal" type="button" class="text-sm text-green-600 hover:text-green-800 font-medium">
                                            + Prescribe Medication
                                        </button>
                                    </div>
                                    <p class="text-sm text-gray-500 mt-2">No prescriptions added for this visit yet.</p>
                                </div>
                            @endif

                            <!-- Consultation Form -->
                            <div class="border-t border-gray-200 pt-4">
                                <h4 class="text-md font-semibold text-gray-900 mb-4">Consultation Details</h4>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                    <div>
                                        <x-input-label for="consultation_type" :value="__('Consultation Type *')" />
                                        <select id="consultation_type" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="consultation_type" required>
                                            <option value="initial">Initial</option>
                                            <option value="follow_up">Follow-up</option>
                                            <option value="emergency">Emergency</option>
                                            <option value="telemedicine">Telemedicine</option>
                                            <option value="specialist">Specialist</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('consultation_type')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="duration" :value="__('Duration (minutes) *')" />
                                        <x-text-input id="duration" class="block mt-1 w-full" type="number" wire:model="duration" min="15" max="480" required />
                                        <x-input-error :messages="$errors->get('duration')" class="mt-1" />
                                    </div>
                                </div>

                                <div class="space-y-4">
                                    <div>
                                        <x-input-label for="chief_complaint" :value="__('Chief Complaint *')" />
                                        <textarea id="chief_complaint" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="chief_complaint" required></textarea>
                                        <x-input-error :messages="$errors->get('chief_complaint')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="history_of_present_illness" :value="__('History of Present Illness')" />
                                        <textarea id="history_of_present_illness" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="history_of_present_illness"></textarea>
                                        <x-input-error :messages="$errors->get('history_of_present_illness')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="physical_examination" :value="__('Physical Examination')" />
                                        <textarea id="physical_examination" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="physical_examination"></textarea>
                                        <x-input-error :messages="$errors->get('physical_examination')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="diagnosis" :value="__('Diagnosis')" />
                                        <textarea id="diagnosis" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="diagnosis"></textarea>
                                        <x-input-error :messages="$errors->get('diagnosis')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="treatment_plan" :value="__('Treatment Plan')" />
                                        <textarea id="treatment_plan" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="treatment_plan"></textarea>
                                        <x-input-error :messages="$errors->get('treatment_plan')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="follow_up_instructions" :value="__('Follow-up Instructions')" />
                                        <textarea id="follow_up_instructions" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="follow_up_instructions"></textarea>
                                        <x-input-error :messages="$errors->get('follow_up_instructions')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="notes" :value="__('Additional Notes')" />
                                        <textarea id="notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="notes"></textarea>
                                        <x-input-error :messages="$errors->get('notes')" class="mt-1" />
                                    </div>
                                </div>
                            </div>

                            <div class="flex justify-between items-center pt-4 border-t border-gray-200">
                                <div class="flex space-x-4">
                                    <button wire:click.stop="openPrescriptionModal" type="button" class="text-sm text-green-600 hover:text-green-800 font-medium">
                                        + Prescribe Medication
                                    </button>
                                    <button wire:click="openSurgeryModal" type="button" class="text-sm text-purple-600 hover:text-purple-800 font-medium">
                                        + Book Surgery
                                    </button>
                                    <button wire:click="openAdmissionModal" type="button" class="text-sm text-red-600 hover:text-red-800 font-medium">
                                        + Admit Patient
                                    </button>
                                </div>
                                <div class="flex space-x-3">
                                    <button type="button" wire:click="closeConsultationModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                        Cancel
                                    </button>
                                    <x-primary-button wire:loading.attr="disabled" wire:target="saveConsultation" class="text-sm">
                                        <span wire:loading.remove wire:target="saveConsultation">Save Consultation</span>
                                        <span wire:loading wire:target="saveConsultation">Saving...</span>
                                    </x-primary-button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Lab Request Modal -->
    @if($showLabRequestModal && $selectedVisitId && $selectedPatient)
        @livewire(\App\Livewire\Labs\LabRequestForm::class, ['visitId' => $selectedVisitId, 'patientId' => $selectedPatient->id], key('lab-request-' . $selectedVisitId))
    @endif

    <!-- Admission Modal -->
    @if($showAdmissionModal && $selectedVisit && $selectedPatient)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true" style="z-index: 10000;">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeAdmissionModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Admit Patient
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ $selectedPatient->full_name }} • {{ $selectedPatient->patient_id }}
                                </p>
                            </div>
                            <button wire:click="closeAdmissionModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="saveAdmission" class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="ward" :value="__('Ward *')" />
                                    <x-text-input id="ward" class="block mt-1 w-full" type="text" wire:model="ward" placeholder="e.g., General Ward, ICU, Pediatrics" required />
                                    <x-input-error :messages="$errors->get('ward')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="room_number" :value="__('Room Number')" />
                                    <x-text-input id="room_number" class="block mt-1 w-full" type="text" wire:model="room_number" placeholder="e.g., 101, 202" />
                                    <x-input-error :messages="$errors->get('room_number')" class="mt-1" />
                                </div>
                            </div>

                            <div>
                                <x-input-label for="bed_number" :value="__('Bed Number')" />
                                <x-text-input id="bed_number" class="block mt-1 w-full" type="text" wire:model="bed_number" placeholder="e.g., A1, B2" />
                                <x-input-error :messages="$errors->get('bed_number')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="admission_reason" :value="__('Admission Reason *')" />
                                <textarea id="admission_reason" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="admission_reason" placeholder="Provide detailed reason for admission..." required></textarea>
                                <x-input-error :messages="$errors->get('admission_reason')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="admission_notes" :value="__('Additional Notes')" />
                                <textarea id="admission_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="admission_notes" placeholder="Any additional notes or instructions..."></textarea>
                                <x-input-error :messages="$errors->get('admission_notes')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <p class="text-xs text-yellow-800">
                                    <strong>Note:</strong> Admitting a patient will update the visit status to "Admitted" and create an admission record. The patient will be moved to the admissions management system.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeAdmissionModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="saveAdmission" class="text-sm">
                                    <span wire:loading.remove wire:target="saveAdmission">Admit Patient</span>
                                    <span wire:loading wire:target="saveAdmission">Admitting...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Surgery Booking Modal -->
    @if($showSurgeryModal && $selectedVisit && $selectedPatient)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true" style="z-index: 10000;">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeSurgeryModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-3xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Book Surgery
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ $selectedPatient->full_name }} • {{ $selectedPatient->patient_id }}
                                </p>
                            </div>
                            <button wire:click="closeSurgeryModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="bookSurgery" class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="surgery_type" :value="__('Surgery Type *')" />
                                    <x-text-input id="surgery_type" class="block mt-1 w-full" type="text" wire:model="surgery_type" placeholder="e.g., General, Orthopedic, Cardiac" required />
                                    <x-input-error :messages="$errors->get('surgery_type')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="procedure_name" :value="__('Procedure Name *')" />
                                    <x-text-input id="procedure_name" class="block mt-1 w-full" type="text" wire:model="procedure_name" placeholder="e.g., Appendectomy, Knee Replacement" required />
                                    <x-input-error :messages="$errors->get('procedure_name')" class="mt-1" />
                                </div>
                            </div>

                            <div>
                                <x-input-label for="surgery_indication" :value="__('Surgery Indication *')" />
                                <textarea id="surgery_indication" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="surgery_indication" placeholder="Provide detailed indication for surgery..." required></textarea>
                                <x-input-error :messages="$errors->get('surgery_indication')" class="mt-1" />
                            </div>

                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <x-input-label for="scheduled_date" :value="__('Scheduled Date *')" />
                                    <x-text-input id="scheduled_date" class="block mt-1 w-full" type="date" wire:model="scheduled_date" required />
                                    <x-input-error :messages="$errors->get('scheduled_date')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="scheduled_time" :value="__('Scheduled Time *')" />
                                    <x-text-input id="scheduled_time" class="block mt-1 w-full" type="time" wire:model="scheduled_time" required />
                                    <x-input-error :messages="$errors->get('scheduled_time')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="estimated_duration" :value="__('Duration (minutes) *')" />
                                    <x-text-input id="estimated_duration" class="block mt-1 w-full" type="number" wire:model="estimated_duration" min="15" max="1440" required />
                                    <x-input-error :messages="$errors->get('estimated_duration')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="operation_room_id" :value="__('Operation Room')" />
                                    <select id="operation_room_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="operation_room_id">
                                        <option value="">Select Operation Room</option>
                                        @foreach(\App\Models\OperationRoom::where('is_active', true)->orderBy('room_number')->get() as $room)
                                            <option value="{{ $room->id }}">{{ $room->room_number }} - {{ $room->name }} ({{ ucfirst($room->status) }})</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('operation_room_id')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="assistant_surgeon_id" :value="__('Assistant Surgeon')" />
                                    <select id="assistant_surgeon_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="assistant_surgeon_id">
                                        <option value="">Select Assistant Surgeon</option>
                                        @foreach(\App\Models\User::where(function($q) { $q->where('role', 'doctor')->orWhere('role', 'staff')->orWhereNull('role'); })->orderBy('name')->get() as $doctor)
                                            <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('assistant_surgeon_id')" class="mt-1" />
                                </div>
                            </div>

                            <div>
                                <x-input-label for="anesthesiologist_id" :value="__('Anesthesiologist')" />
                                <select id="anesthesiologist_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="anesthesiologist_id">
                                    <option value="">Select Anesthesiologist</option>
                                    @foreach(\App\Models\User::where(function($q) { $q->where('role', 'doctor')->orWhere('role', 'staff')->orWhereNull('role'); })->orderBy('name')->get() as $doctor)
                                        <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('anesthesiologist_id')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="surgery_notes" :value="__('Additional Notes')" />
                                <textarea id="surgery_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="surgery_notes" placeholder="Any additional notes or instructions..."></textarea>
                                <x-input-error :messages="$errors->get('surgery_notes')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> The surgery will be scheduled and an operation number will be generated. The operation room status will be updated if a room is assigned.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeSurgeryModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="bookSurgery" class="text-sm">
                                    <span wire:loading.remove wire:target="bookSurgery">Book Surgery</span>
                                    <span wire:loading wire:target="bookSurgery">Booking...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Prescription Modal -->
    @if($showPrescriptionModal && $selectedVisit && $selectedPatient)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true" style="z-index: 10000;">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click.stop="closePrescriptionModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Prescribe Medication
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ $selectedPatient->full_name }} • {{ $selectedPatient->patient_id }}
                                </p>
                            </div>
                            <button type="button" wire:click.stop="closePrescriptionModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="savePrescription" class="space-y-4">
                            <!-- Common Date Fields -->
                            <div class="grid grid-cols-2 gap-4 mb-6 p-4 bg-gray-50 rounded-lg">
                                <div>
                                    <x-input-label for="prescription_date" :value="__('Prescription Date *')" />
                                    <x-text-input id="prescription_date" class="block mt-1 w-full" type="date" wire:model="prescription_date" required />
                                    <x-input-error :messages="$errors->get('prescription_date')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="prescription_valid_until" :value="__('Valid Until *')" />
                                    <x-text-input id="prescription_valid_until" class="block mt-1 w-full" type="date" wire:model="prescription_valid_until" required />
                                    <x-input-error :messages="$errors->get('prescription_valid_until')" class="mt-1" />
                                </div>
                            </div>

                            <!-- Prescription Rows -->
                            <div class="space-y-6 max-h-[60vh] overflow-y-auto">
                                @foreach($prescriptionItems as $index => $prescription)
                                    <div class="border border-gray-200 rounded-lg p-4 bg-white">
                                        <div class="flex justify-between items-center mb-4">
                                            <h4 class="text-sm font-semibold text-gray-700">Prescription #{{ $index + 1 }}</h4>
                                            @if(count($prescriptionItems) > 1)
                                                <button type="button" wire:click.stop="removePrescriptionRow({{ $index }})" class="text-red-600 hover:text-red-800 text-sm font-medium">
                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                    </svg>
                                                </button>
                                            @endif
                                        </div>

                                        <div class="space-y-4">
                                            <div>
                                                <x-input-label for="prescription_drug_id_{{ $index }}" :value="__('Drug *')" />
                                                <select id="prescription_drug_id_{{ $index }}" wire:model="prescriptionItems.{{ $index }}.drug_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" required>
                                                    <option value="">Select Drug</option>
                                                    @foreach($drugs ?? [] as $drug)
                                                        <option value="{{ $drug->id }}">{{ ucwords(strtolower($drug->name)) }} ({{ ucwords(strtolower($drug->generic_name)) }})</option>
                                                    @endforeach
                                                </select>
                                                <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.drug_id')" class="mt-1" />
                                            </div>

                                            <div class="grid grid-cols-3 gap-4">
                                                <div>
                                                    <x-input-label for="prescription_dosage_{{ $index }}" :value="__('Dosage *')" />
                                                    <x-text-input id="prescription_dosage_{{ $index }}" class="block mt-1 w-full" type="text" wire:model="prescriptionItems.{{ $index }}.dosage" placeholder="e.g., 500mg" required />
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.dosage')" class="mt-1" />
                                                </div>
                                                <div>
                                                    <x-input-label for="prescription_frequency_{{ $index }}" :value="__('Frequency *')" />
                                                    <x-text-input id="prescription_frequency_{{ $index }}" class="block mt-1 w-full" type="text" wire:model="prescriptionItems.{{ $index }}.frequency" placeholder="e.g., Twice daily" required />
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.frequency')" class="mt-1" />
                                                </div>
                                                <div>
                                                    <x-input-label for="prescription_quantity_{{ $index }}" :value="__('Quantity *')" />
                                                    <x-text-input id="prescription_quantity_{{ $index }}" class="block mt-1 w-full" type="number" min="1" wire:model="prescriptionItems.{{ $index }}.quantity" required />
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.quantity')" class="mt-1" />
                                                </div>
                                            </div>

                                            <div class="grid grid-cols-3 gap-4">
                                                <div>
                                                    <x-input-label for="prescription_duration_{{ $index }}" :value="__('Duration (days) *')" />
                                                    <x-text-input id="prescription_duration_{{ $index }}" class="block mt-1 w-full" type="number" min="1" max="365" wire:model="prescriptionItems.{{ $index }}.duration" required />
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.duration')" class="mt-1" />
                                                </div>
                                                <div>
                                                    <x-input-label for="prescription_status_{{ $index }}" :value="__('Status *')" />
                                                    <select id="prescription_status_{{ $index }}" wire:model="prescriptionItems.{{ $index }}.status" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" required>
                                                        <option value="active">Active</option>
                                                        <option value="dispensed">Dispensed</option>
                                                        <option value="expired">Expired</option>
                                                        <option value="cancelled">Cancelled</option>
                                                    </select>
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.status')" class="mt-1" />
                                                </div>
                                                <div>
                                                    <x-input-label for="prescription_max_refills_{{ $index }}" :value="__('Max Refills *')" />
                                                    <x-text-input id="prescription_max_refills_{{ $index }}" class="block mt-1 w-full" type="number" min="0" max="12" wire:model="prescriptionItems.{{ $index }}.max_refills" required />
                                                    <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.max_refills')" class="mt-1" />
                                                </div>
                                            </div>

                                            <div>
                                                <x-input-label for="prescription_instructions_{{ $index }}" :value="__('Instructions')" />
                                                <textarea id="prescription_instructions_{{ $index }}" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="prescriptionItems.{{ $index }}.instructions" placeholder="e.g., Take with food"></textarea>
                                                <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.instructions')" class="mt-1" />
                                            </div>

                                            <div>
                                                <x-input-label for="prescription_notes_{{ $index }}" :value="__('Notes')" />
                                                <textarea id="prescription_notes_{{ $index }}" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="prescriptionItems.{{ $index }}.notes"></textarea>
                                                <x-input-error :messages="$errors->get('prescriptionItems.' . $index . '.notes')" class="mt-1" />
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <!-- Add Prescription Button -->
                            <div class="pt-4 border-t border-gray-200">
                                <button type="button" wire:click.stop="addPrescriptionRow" class="text-green-600 hover:text-green-800 font-medium text-sm flex items-center">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                                    </svg>
                                    Add Another Prescription
                                </button>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200">
                                <button type="button" wire:click.stop="closePrescriptionModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="savePrescription" class="text-sm">
                                    <span wire:loading.remove wire:target="savePrescription">
                                        Create {{ count($prescriptionItems) > 1 ? count($prescriptionItems) . ' Prescriptions' : 'Prescription' }}
                                    </span>
                                    <span wire:loading wire:target="savePrescription">Creating...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
