<div>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Consultations</h2>
                        <button wire:click="openCreateModal" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">+ New Consultation</button>
                    </div>

                    @if (session()->has('message'))
                        <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">{{ session('message') }}</div>
                    @endif

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <x-text-input wire:model.live="search" type="text" placeholder="Search consultations..." class="w-full" />
                        <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm">
                            <option value="">All Statuses</option>
                            <option value="scheduled">Scheduled</option>
                            <option value="in_progress">In Progress</option>
                            <option value="completed">Completed</option>
                            <option value="cancelled">Cancelled</option>
                        </select>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Doctor</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($consultations as $consultation)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $consultation->patient->full_name }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucwords(strtolower($consultation->doctor->name)) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucfirst(str_replace('_', ' ', $consultation->consultation_type)) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $consultation->consultation_date->format('M d, Y') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($consultation->status === 'completed') bg-green-100 text-green-800
                                                @elseif($consultation->status === 'in_progress') bg-blue-100 text-blue-800
                                                @elseif($consultation->status === 'cancelled') bg-red-100 text-red-800
                                                @else bg-yellow-100 text-yellow-800
                                                @endif">{{ ucfirst(str_replace('_', ' ', $consultation->status)) }}</span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <button wire:click="openEditModal({{ $consultation->id }})" class="text-indigo-600 hover:text-indigo-900 mr-3">Edit</button>
                                            <button wire:click="delete({{ $consultation->id }})" wire:confirm="Are you sure?" class="text-red-600 hover:text-red-900">Delete</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No consultations found</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">{{ $consultations->links() }}</div>
                </div>
            </div>
        </div>
    </div>

    @if($showCreateModal || $showEditModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-[700px] shadow-lg rounded-md bg-white max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-medium mb-4">{{ $editingConsultation ? 'Edit Consultation' : 'New Consultation' }}</h3>
                <form wire:submit.prevent="save" class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <x-input-label for="patient_id" value="Patient *" />
                            <div class="relative">
                                <input 
                                    type="text" 
                                    id="patient_search"
                                    wire:model.live.debounce.300ms="patientSearch"
                                    wire:keyup="searchPatients"
                                    placeholder="Search by name, ID, phone, or email..."
                                    class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md"
                                    autocomplete="off"
                                />
                                @if(count($searchResults) > 0 && !$patient_id)
                                    <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                        @foreach($searchResults as $patient)
                                            <button 
                                                type="button"
                                                wire:click="selectPatient({{ $patient->id }})"
                                                class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                            >
                                                <div class="font-medium">{{ $patient->full_name }}</div>
                                                <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                            </button>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                            @if($patient_id)
                                <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                    <span class="text-sm text-green-800">✓ Patient selected</span>
                                </div>
                            @endif
                            <input type="hidden" wire:model="patient_id" />
                        </div>
                        <div>
                            <x-input-label for="doctor_id" value="Doctor *" />
                            <select wire:model="doctor_id" id="doctor_id" class="block mt-1 w-full border-gray-300 rounded-md">
                                <option value="">Select Doctor</option>
                                @foreach($doctors as $doctor)
                                    <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <x-input-label for="consultation_type" value="Type *" />
                            <select wire:model="consultation_type" id="consultation_type" class="block mt-1 w-full border-gray-300 rounded-md">
                                <option value="initial">Initial</option>
                                <option value="follow_up">Follow Up</option>
                                <option value="emergency">Emergency</option>
                                <option value="telemedicine">Telemedicine</option>
                                <option value="specialist">Specialist</option>
                            </select>
                        </div>
                        <div>
                            <x-input-label for="status" value="Status *" />
                            <select wire:model="status" id="status" class="block mt-1 w-full border-gray-300 rounded-md">
                                <option value="scheduled">Scheduled</option>
                                <option value="in_progress">In Progress</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <x-input-label for="chief_complaint" value="Chief Complaint *" />
                        <textarea wire:model="chief_complaint" id="chief_complaint" class="block mt-1 w-full border-gray-300 rounded-md" rows="2"></textarea>
                    </div>
                    <div>
                        <x-input-label for="diagnosis" value="Diagnosis" />
                        <textarea wire:model="diagnosis" id="diagnosis" class="block mt-1 w-full border-gray-300 rounded-md" rows="2"></textarea>
                    </div>
                    <div>
                        <x-input-label for="treatment_plan" value="Treatment Plan" />
                        <textarea wire:model="treatment_plan" id="treatment_plan" class="block mt-1 w-full border-gray-300 rounded-md" rows="2"></textarea>
                    </div>
                    <div class="flex justify-end space-x-3 pt-4">
                        <button type="button" wire:click="closeModals" class="px-4 py-2 bg-gray-300 rounded-lg">Cancel</button>
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg">{{ $editingConsultation ? 'Update' : 'Create' }}</button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>















