<div>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Billing & Payments</h2>
                        <button wire:click="openCreateModal" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">+ New Bill</button>
                    </div>

                    @if (session()->has('message'))
                        <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">{{ session('message') }}</div>
                    @endif

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <x-text-input wire:model.live="search" type="text" placeholder="Search bills..." class="w-full" />
                        <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm">
                            <option value="">All Statuses</option>
                            <option value="pending">Pending</option>
                            <option value="paid">Paid</option>
                            <option value="partial">Partial</option>
                            <option value="overdue">Overdue</option>
                        </select>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Bill #</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Due Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($bills as $bill)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">{{ $bill->bill_number }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $bill->patient->full_name }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">₦{{ number_format($bill->total_amount, 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($bill->status === 'paid') bg-green-100 text-green-800
                                                @elseif($bill->status === 'overdue') bg-red-100 text-red-800
                                                @elseif($bill->status === 'partial') bg-blue-100 text-blue-800
                                                @else bg-yellow-100 text-yellow-800
                                                @endif">{{ ucfirst($bill->status) }}</span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $bill->due_date->format('M d, Y') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <button wire:click="openPaymentModal({{ $bill->id }})" class="text-indigo-600 hover:text-indigo-900">Payment</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No bills found</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">{{ $bills->links() }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Bill Modal -->
    @if($showCreateModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-[600px] shadow-lg rounded-md bg-white max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-medium mb-4">New Bill</h3>
                <form wire:submit.prevent="saveBill" class="space-y-4">
                    <div>
                        <x-input-label for="patient_id" value="Patient *" />
                        <div class="relative">
                            <input 
                                type="text" 
                                id="patient_search"
                                wire:model.live.debounce.300ms="patientSearch"
                                wire:keyup="searchPatients"
                                placeholder="Search by name, ID, phone, or email..."
                                class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md"
                                autocomplete="off"
                            />
                            @if(count($searchResults) > 0 && !$patient_id)
                                <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                    @foreach($searchResults as $patient)
                                        <button 
                                            type="button"
                                            wire:click="selectPatient({{ $patient->id }})"
                                            class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                        >
                                            <div class="font-medium">{{ $patient->full_name }}</div>
                                            <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                        </button>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                        @if($patient_id)
                            <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                <span class="text-sm text-green-800">✓ Patient selected</span>
                            </div>
                        @endif
                        <input type="hidden" wire:model="patient_id" />
                        <x-input-error :messages="$errors->get('patient_id')" class="mt-2" />
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <x-input-label for="subtotal" value="Subtotal *" />
                            <x-text-input wire:model="subtotal" type="number" step="0.01" min="0" class="block mt-1 w-full" />
                            <x-input-error :messages="$errors->get('subtotal')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="tax_amount" value="Tax Amount *" />
                            <x-text-input wire:model="tax_amount" type="number" step="0.01" min="0" class="block mt-1 w-full" />
                            <x-input-error :messages="$errors->get('tax_amount')" class="mt-2" />
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <x-input-label for="discount_amount" value="Discount *" />
                            <x-text-input wire:model="discount_amount" type="number" step="0.01" min="0" class="block mt-1 w-full" />
                            <x-input-error :messages="$errors->get('discount_amount')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="total_amount" value="Total Amount *" />
                            <x-text-input wire:model="total_amount" type="number" step="0.01" readonly class="block mt-1 w-full bg-gray-100" />
                            <x-input-error :messages="$errors->get('total_amount')" class="mt-2" />
                        </div>
                    </div>
                    <div class="flex items-center">
                        <input wire:model="insurance_covered" type="checkbox" id="insurance_covered" class="rounded">
                        <x-input-label for="insurance_covered" value="Insurance Covered" class="ml-2" />
                    </div>
                    <div>
                        <x-input-label for="due_date" value="Due Date *" />
                        <x-text-input wire:model="due_date" type="date" class="block mt-1 w-full" />
                        <x-input-error :messages="$errors->get('due_date')" class="mt-2" />
                    </div>
                    <div class="flex justify-end space-x-3 pt-4">
                        <button type="button" wire:click="closeModals" class="px-4 py-2 bg-gray-300 rounded-lg">Cancel</button>
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg">Create</button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Payment Modal -->
    @if($showPaymentModal && $selectedBill)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                <h3 class="text-lg font-medium mb-4">Process Payment</h3>
                <div class="mb-4 p-3 bg-gray-50 rounded">
                    <p class="text-sm text-gray-600">Bill: {{ $selectedBill->bill_number }}</p>
                    <p class="text-sm text-gray-600">Total: ₦{{ number_format($selectedBill->total_amount, 2) }}</p>
                    <p class="text-sm text-gray-600">Balance: ₦{{ number_format($selectedBill->balance, 2) }}</p>
                </div>
                <form wire:submit.prevent="savePayment" class="space-y-4">
                    <div>
                        <x-input-label for="payment_amount" value="Payment Amount *" />
                        <x-text-input wire:model="payment_amount" type="number" step="0.01" min="0.01" max="{{ $selectedBill->balance }}" class="block mt-1 w-full" />
                        <x-input-error :messages="$errors->get('payment_amount')" class="mt-2" />
                    </div>
                    <div>
                        <x-input-label for="payment_method" value="Payment Method *" />
                        <select wire:model="payment_method" id="payment_method" class="block mt-1 w-full border-gray-300 rounded-md">
                            <option value="cash">Cash</option>
                            <option value="card">Card</option>
                            <option value="bank_transfer">Bank Transfer</option>
                            <option value="insurance">Insurance</option>
                            <option value="cheque">Cheque</option>
                        </select>
                        <x-input-error :messages="$errors->get('payment_method')" class="mt-2" />
                    </div>
                    <div>
                        <x-input-label for="payment_reference" value="Reference" />
                        <x-text-input wire:model="payment_reference" type="text" class="block mt-1 w-full" />
                        <x-input-error :messages="$errors->get('payment_reference')" class="mt-2" />
                    </div>
                    <div class="flex justify-end space-x-3 pt-4">
                        <button type="button" wire:click="closeModals" class="px-4 py-2 bg-gray-300 rounded-lg">Cancel</button>
                        <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg">Process Payment</button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>















