<div>
    <div class="max-w-6xl mx-auto">
        <div class="bg-white shadow-sm sm:rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <svg class="w-5 h-5 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                    AI Diagnosis Assistant
                </h3>
                <p class="text-sm text-gray-600 mt-1">Get AI-powered diagnostic suggestions based on symptoms and patient data</p>
            </div>

            <div class="p-6">
                <form wire:submit.prevent="getDiagnosisSuggestions">
                    <!-- Symptoms Section -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Symptoms</label>
                        <div class="flex space-x-2 mb-3">
                            <input 
                                type="text" 
                                wire:model="symptomInput"
                                placeholder="Enter a symptom..."
                                class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                            >
                            <button type="button" 
                                    wire:click="addSymptom"
                                    class="bg-blue-500 hover:bg-blue-700 text-white px-4 py-2 rounded">
                                Add
                            </button>
                        </div>
                        
                        @if(count($symptoms) > 0)
                            <div class="flex flex-wrap gap-2">
                                @foreach($symptoms as $index => $symptom)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm bg-blue-100 text-blue-800">
                                        {{ $symptom }}
                                        <button type="button" 
                                                wire:click="removeSymptom({{ $index }})"
                                                class="ml-2 text-blue-600 hover:text-blue-800">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                        </button>
                                    </span>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    <!-- Vital Signs Section -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-3">Vital Signs (Optional)</label>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-xs font-medium text-gray-600 mb-1">Blood Pressure</label>
                                <input 
                                    type="text" 
                                    wire:model="vitalSigns.blood_pressure"
                                    placeholder="e.g., 120/80"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                                >
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-600 mb-1">Temperature (°F)</label>
                                <input 
                                    type="number" 
                                    step="0.1"
                                    wire:model="vitalSigns.temperature"
                                    placeholder="e.g., 98.6"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                                >
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-600 mb-1">Heart Rate (BPM)</label>
                                <input 
                                    type="number" 
                                    wire:model="vitalSigns.heart_rate"
                                    placeholder="e.g., 72"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                                >
                            </div>
                            <div>
                                <label □="block text-xs font-medium text-gray-600 mb-1">Respiratory Rate</label>
                                <input 
                                    type="number" 
                                    wire:model="vitalSigns.respiratory_rate"
                                    placeholder="e.g., 16"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                                >
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-600 mb-1">Oxygen Saturation (%)</label>
                                <input 
                                    type="number" 
                                    wire:model="vitalSigns.oxygen_saturation"
                                    placeholder="e.g., 98"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                                >
                            </div>
                        </div>
                    </div>

                    <!-- Patient History Section -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-中 mb-2">Relevant Medical History (Optional)</label>
                        <div class="flex space-x-2 mb-3">
                            <input 
                                type="text" 
                                wire:model="historyInput"
                                placeholder="Enter relevant medical history..."
                                class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                            >
                            <button type="button" 
                                    wire:click="addHistory"
                                    class="bg-gray-500 hover:bg-gray-700 text-white px-4 py-2 rounded">
                                Add
                            </button>
</div>

                        @if(count($patientHistory) > 0)
                            <div class="space-y-2">
                                @foreach($patientHistory as $index => $history)
                                    <div class="flex items-center justify-between bg-gray-50 border border-gray-200 rounded-lg p-3">
                                        <span class="text-sm text-gray-700">{{ $history }}</span>
                                        <button type="button" 
                                                wire:click="removeHistory({{ $index }})"
                                                class="text-red-500 hover:text-red-700">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    <!-- Submit Button -->
                    <div class="flex justify-end">
                        <button type="submit"
                                wire:loading.attr="disabled"
                                class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded disabled:opacity-50">
                            <span wire:loading.remove wire:target="getDiagnosisSuggestions">
                                Get AI Diagnosis Suggestions
                            </span>
                            <span wire:loading wire:target="getDiagnosisSuggestions">
                                <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white inline" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                Analyzing...
                            </span>
                        </button>
                    </div>
                </form>

                <!-- Diagnosis Results -->
                @if($diagnosisResults)
                    <div class="border-t border-gray-200 pt-6 mt-6">
                        <div class="flex items-center mb-4">
                            <h4 class="text-lg font-medium text-gray-900">AI Diagnosis Analysis</h4>
                            @if($diagnosisResults['ai_generated'])
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    AI Generated
                                </span>
                            @else
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    Fallback Analysis
                                </span>
                            @endif
                        </div>

                        <!-- Urgency Level -->
                        <div class="mb-4">
                            <div class="flex items-center">
                                <span class="text-sm font-medium text-gray-700 mr-2">Urgency Level:</span>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                    @if($this->urgencyLevelColor === 'green') bg-green-100 text-green-800
                                    @elseif($this->urgencyLevelColor === 'yellow') bg-yellow-100 text-yellow-800
                                    @elseif($this->urgencyLevelColor === 'orange') bg-orange-100 text-orange-800
                                    @elseif($this->urgencyLevelColor === 'red') bg-red-100 text-red-800
                                    @else bg-gray-100 text-gray-800 @endif">
                                    {{ ucfirst($diagnosisResults['urgency_level'] ?? 'Medium') }}
                                </span>
                            </div>
                        </div>

                        <!-- Differential Diagnoses -->
                        @if(!empty($diagnosisResults['diagnoses']))
                            <div class="mb-6">
                                <h5 class="text-sm font-medium text-gray-700 mb-3">Differential Diagnoses:</h5>
                                <div class="space-y-3">
                                    @foreach($diagnosisResults['diagnoses'] as $index => $diagnosis)
                                        <div class="border border-gray-200 rounded-lg p-4">
                                            <div class="flex items-center justify-between mb-2">
                                                <h6 class="font-medium text-gray-900">
                                                    {{ $index + 1 }}. {{ $diagnosis['condition'] ?? 'Unknown Condition' }}
                                                </h6>
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                                    @if(($diagnosis['confidence'] ?? 'medium') === 'high') bg-green-100 text-green-800
                                                    @elseif(($diagnosis['confidence'] ?? 'medium') === 'medium') bg-yellow-100 text-yellow-800
                                                    @else bg-gray-100 text-gray-800 @endif">
                                                    {{ ucfirst($diagnosis['confidence'] ?? 'Medium') }} Confidence
                                                </span>
                                            </div>
                                            @if(!empty($diagnosis['description']))
                                                <p class="text-sm text-gray-600">{{ $diagnosis['description'] }}</p>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        <!-- Diagnostic Tests -->
                        @if(!empty($diagnosisResults['diagnostic_tests']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Recommended Diagnostic Tests:</h5>
                                <ul class="list-disc list-inside space-y-1 text-sm text-gray-600">
                                    @foreach($diagnosisResults['diagnostic_tests'] as $test)
                                        <li>{{ $test }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <!-- Red Flags -->
                        @if(!empty($diagnosisResults['red_flags']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Red Flag Symptoms to Monitor:</h5>
                                <div class="bg-red-50 border border-red-200 rounded-lg p-3">
                                    <ul class="list-disc list-inside space-y-1 text-sm text-red-700">
                                        @foreach($diagnosisResults['red_flags'] as $flag)
                                            <li>{{ $flag }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endif

                        <!-- Confidence Notes -->
                        @if(!empty($diagnosisResults['confidence_notes']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Analysis Notes:</h5>
                                <p class="text-sm text-gray-600">{{ $diagnosisResults['confidence_notes'] }}</p>
                            </div>
                        @endif

                        <!-- Important Disclaimer -->
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-yellow-800">Important Medical Disclaimer</h3>
                                    <div class="mt-2 text-sm text-yellow-700">
                                        <p>This AI analysis is for educational and assistance purposes only. It should never replace professional medical diagnosis, treatment, or judgment. Always consult with qualified healthcare professionals for proper medical care and diagnosis.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>