<div>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-6">
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">Admissions Management</h2>
                            <p class="text-gray-600 mt-1">Manage patient admissions and discharges</p>
                        </div>
                    </div>

                    @if (session()->has('message'))
                        <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                            {{ session('message') }}
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Filters -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <x-text-input wire:model.live="search" type="text" placeholder="Search by patient name, ID, admission number, ward, or room..." class="w-full" />
                        </div>
                        <div>
                            <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">All Statuses</option>
                                <option value="admitted">Admitted</option>
                                <option value="discharged">Discharged</option>
                                <option value="transferred">Transferred</option>
                            </select>
                        </div>
                    </div>

                    <!-- Admissions Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission #</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ward</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Room/Bed</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admitted By</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($admissions as $admission)
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            {{ $admission->admission_number }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="text-sm font-medium text-gray-900">{{ $admission->patient->full_name }}</div>
                                            <div class="text-sm text-gray-500">{{ $admission->patient->patient_id }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $admission->display_ward ?? 'N/A' }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            @if($admission->room_number || $admission->bed_number)
                                                {{ $admission->room_number ? 'Room: ' . $admission->room_number : '' }}
                                                {{ $admission->room_number && $admission->bed_number ? ' / ' : '' }}
                                                {{ $admission->bed_number ? 'Bed: ' . $admission->bed_number : '' }}
                                            @else
                                                <span class="text-gray-400">-</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $admission->admission_date->format('M d, Y h:i A') }}
                                            @if($admission->discharge_date)
                                                <div class="text-xs text-gray-500">
                                                    Discharged: {{ $admission->discharge_date->format('M d, Y h:i A') }}
                                                </div>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ ucwords(strtolower($admission->admittedBy->name)) }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-{{ $admission->status_color }}-100 text-{{ $admission->status_color }}-800">
                                                {{ $admission->status_label }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <div class="flex space-x-2">
                                                @if($admission->status === 'admitted')
                                                    <button wire:click="openDischargeModal({{ $admission->id }})" class="text-green-600 hover:text-green-900">
                                                        Discharge
                                                    </button>
                                                @endif
                                                <button wire:click="$dispatch('open-modal', { type: 'view-admission', id: {{ $admission->id }} })" class="text-blue-600 hover:text-blue-900">
                                                    View
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="px-6 py-4 text-center text-gray-500">No admissions found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $admissions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Discharge Modal -->
    @if($showDischargeModal && $selectedAdmission)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeDischargeModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Discharge Patient
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ $selectedAdmission->patient->full_name }} • {{ $selectedAdmission->admission_number }}
                                </p>
                            </div>
                            <button wire:click="closeDischargeModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="discharge" class="space-y-4">
                            <div>
                                <x-input-label for="discharge_notes" :value="__('Discharge Notes')" />
                                <textarea id="discharge_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="discharge_notes" placeholder="Notes about the discharge..."></textarea>
                                <x-input-error :messages="$errors->get('discharge_notes')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="discharge_instructions" :value="__('Discharge Instructions')" />
                                <textarea id="discharge_instructions" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="discharge_instructions" placeholder="Instructions for the patient after discharge..."></textarea>
                                <x-input-error :messages="$errors->get('discharge_instructions')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> Discharging the patient will update the admission status and mark the associated visit as checked out (if applicable).
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeDischargeModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="discharge" class="text-sm">
                                    <span wire:loading.remove wire:target="discharge">Discharge Patient</span>
                                    <span wire:loading wire:target="discharge">Discharging...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
