<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="font-semibold text-2xl text-gray-800 leading-tight">
                    {{ __('Hospital Management Dashboard') }}
                </h2>
                <p class="text-sm text-gray-500 mt-1">Welcome back, {{ auth()->user()->name }}!</p>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(auth()->user()->canViewPatients())
            <!-- Patient Search Bar -->
            <div class="bg-white overflow-hidden rounded-xl mb-8 border border-gray-100">
                <div class="bg-gradient-to-r from-blue-50 to-indigo-50 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-blue-500 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Quick Patient Search</h3>
                            <p class="text-sm text-gray-600">Search by name, ID, email, or phone number</p>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <form action="{{ route('patients.index') }}" method="GET" class="flex gap-4">
                        <div class="flex-1 relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                            <input 
                                type="text" 
                                name="search" 
                                placeholder="Enter patient name, ID, email, or phone..." 
                                value="{{ request('search') }}"
                                class="w-full pl-12 pr-4 py-4 border-2 border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-base transition-all duration-200"
                                autofocus
                            />
                        </div>
                        <button 
                            type="submit" 
                            class="bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold py-4 px-8 rounded-xl flex items-center gap-2 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            Search
                        </button>
                        <a 
                            href="{{ route('patients.index') }}" 
                            class="bg-white border-2 border-gray-300 hover:border-gray-400 text-gray-700 hover:text-gray-900 font-semibold py-4 px-8 rounded-xl flex items-center gap-2 transition-all duration-200 shadow-md hover:shadow-lg"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                            View All
                        </a>
                    </form>
                </div>
            </div>
            @endif

            <!-- Dashboard Widgets Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                <!-- Today's Schedule Widget -->
                <div class="bg-white rounded-xl border border-gray-100 overflow-hidden">
                    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center gap-3">
                            <div class="p-2 bg-blue-500 rounded-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900">Today's Schedule</h3>
                                <p class="text-sm text-gray-600">{{ \Carbon\Carbon::now('+01:00')->format('l, F j, Y') }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        @php
                            $todayAppointments = \App\Models\Appointment::with(['patient', 'doctor'])
                                ->whereDate('appointment_date', today())
                                ->orderBy('appointment_time')
                                ->limit(5)
                                ->get()
                                ->filter(function($apt) {
                                    // Filter out appointments with null patient relationships (should use patient_name accessor instead)
                                    return true;
                                });
                        @endphp
                        
                        @if($todayAppointments->count() > 0)
                            <div class="space-y-3">
                                @foreach($todayAppointments as $appointment)
                                    <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-blue-50 transition-colors border border-transparent hover:border-blue-200">
                                        <div class="flex items-center gap-3 flex-1">
                                            <div class="flex-shrink-0">
                                                <div class="w-12 h-12 rounded-lg bg-gradient-to-br from-blue-400 to-indigo-500 flex items-center justify-center text-white font-semibold text-sm">
                                                    {{ \Carbon\Carbon::parse($appointment->appointment_time)->format('H:i') }}
                                                </div>
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <p class="text-sm font-semibold text-gray-900 truncate">{{ $appointment->patient_name }}</p>
                                                <p class="text-xs text-gray-500">Dr. {{ $appointment->doctor->name }} • {{ ucfirst(str_replace('_', ' ', $appointment->type)) }}</p>
                                            </div>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full
                                                @if($appointment->status === 'completed') bg-green-100 text-green-800
                                                @elseif($appointment->status === 'cancelled' || $appointment->status === 'no_show') bg-red-100 text-red-800
                                                @elseif($appointment->status === 'in_progress') bg-purple-100 text-purple-800
                                                @elseif($appointment->status === 'confirmed') bg-blue-100 text-blue-800
                                                @else bg-yellow-100 text-yellow-800
                                                @endif">
                                                {{ ucfirst(str_replace('_', ' ', $appointment->status)) }}
                                            </span>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="mt-4">
                                <a href="{{ route('appointments.index') }}" class="block text-center text-sm text-blue-600 hover:text-blue-700 font-medium py-2">
                                    View all appointments →
                                </a>
                            </div>
                        @else
                            <div class="text-center py-8">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                                <p class="mt-2 text-sm font-medium text-gray-900">No appointments today</p>
                                <p class="mt-1 text-sm text-gray-500">You have a free schedule today.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Pending Tasks Widget -->
                <div class="bg-white rounded-xl border border-gray-100 overflow-hidden">
                    <div class="bg-gradient-to-r from-amber-50 to-yellow-50 px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center gap-3">
                            <div class="p-2 bg-amber-500 rounded-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900">Pending Tasks</h3>
                                <p class="text-sm text-gray-600">Items requiring attention</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <livewire:dashboard.pending-tasks />
                    </div>
                </div>
            </div>

            <!-- Quick Actions Widget -->
            <div class="bg-white shadow-xl rounded-xl border border-gray-100 overflow-hidden mb-8">
                <div class="bg-gradient-to-r from-green-50 to-emerald-50 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-green-500 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Quick Actions</h3>
                            <p class="text-sm text-gray-600">Common tasks and shortcuts</p>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                        @if(auth()->user()->canManagePatients())
                            <a href="{{ route('patients.create') }}" class="flex flex-col items-center justify-center p-4 bg-blue-50 hover:bg-blue-100 rounded-lg border border-blue-200 transition-colors group">
                                <svg class="w-8 h-8 text-blue-600 group-hover:text-blue-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                                </svg>
                                <span class="text-sm font-medium text-blue-700 text-center">New Patient</span>
                            </a>
                        @endif

                        @if(auth()->user()->canManageAppointments())
                            <a href="{{ route('appointments.index') }}" class="flex flex-col items-center justify-center p-4 bg-green-50 hover:bg-green-100 rounded-lg border border-green-200 transition-colors group">
                                <svg class="w-8 h-8 text-green-600 group-hover:text-green-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                                <span class="text-sm font-medium text-green-700 text-center">Schedule</span>
                            </a>
                        @endif

                        @if(auth()->user()->canManagePrescriptions())
                            <a href="{{ route('prescriptions.index') }}" class="flex flex-col items-center justify-center p-4 bg-purple-50 hover:bg-purple-100 rounded-lg border border-purple-200 transition-colors group">
                                <svg class="w-8 h-8 text-purple-600 group-hover:text-purple-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                                </svg>
                                <span class="text-sm font-medium text-purple-700 text-center">Prescribe</span>
                            </a>
                        @endif

                        @if(auth()->user()->canManageBills())
                            <a href="{{ route('bills.index') }}" class="flex flex-col items-center justify-center p-4 bg-yellow-50 hover:bg-yellow-100 rounded-lg border border-yellow-200 transition-colors group">
                                <svg class="w-8 h-8 text-yellow-600 group-hover:text-yellow-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z"></path>
                                </svg>
                                <span class="text-sm font-medium text-yellow-700 text-center">Create Bill</span>
                            </a>
                        @endif

                        @if(auth()->user()->canViewConsultations())
                            <a href="{{ route('consultations.index') }}" class="flex flex-col items-center justify-center p-4 bg-indigo-50 hover:bg-indigo-100 rounded-lg border border-indigo-200 transition-colors group">
                                <svg class="w-8 h-8 text-indigo-600 group-hover:text-indigo-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                </svg>
                                <span class="text-sm font-medium text-indigo-700 text-center">Consultation</span>
                            </a>
                        @endif

                        @if(auth()->user()->canAccessAI())
                            <a href="{{ route('ai.drug-interactions') }}" class="flex flex-col items-center justify-center p-4 bg-pink-50 hover:bg-pink-100 rounded-lg border border-pink-200 transition-colors group">
                                <svg class="w-8 h-8 text-pink-600 group-hover:text-pink-700 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                                </svg>
                                <span class="text-sm font-medium text-pink-700 text-center">AI Tools</span>
                            </a>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <livewire:dashboard.recent-activity />
        </div>
    </div>
</x-app-layout>
