<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="font-semibold text-2xl text-gray-800 leading-tight">
                    {{ __('Health Management Dashboard') }}
                </h2>
                <p class="text-sm text-gray-500 mt-1">Welcome back, {{ auth()->user()->name }}!</p>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Patient Search Bar -->
            <div class="bg-white overflow-hidden shadow-xl rounded-xl mb-8 border border-gray-100">
                <div class="bg-gradient-to-r from-green-50 to-emerald-50 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-green-500 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Quick Patient Search</h3>
                            <p class="text-sm text-gray-600">Search by name, ID, email, or phone number</p>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <form action="{{ route('patients.index') }}" method="GET" class="flex gap-4">
                        <div class="flex-1 relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                            <input 
                                type="text" 
                                name="search" 
                                placeholder="Enter patient name, ID, email, or phone..." 
                                value="{{ request('search') }}"
                                class="w-full pl-12 pr-4 py-4 border-2 border-gray-200 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500 text-base transition-all duration-200"
                                autofocus
                            />
                        </div>
                        <button 
                            type="submit" 
                            class="bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 text-white font-semibold py-4 px-8 rounded-xl flex items-center gap-2 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            Search
                        </button>
                        <a 
                            href="{{ route('patients.index') }}" 
                            class="bg-white border-2 border-gray-300 hover:border-gray-400 text-gray-700 hover:text-gray-900 font-semibold py-4 px-8 rounded-xl flex items-center gap-2 transition-all duration-200 shadow-md hover:shadow-lg"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                            View All
                        </a>
                    </form>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Recent Patients -->
                <div class="bg-white overflow-hidden shadow-xl rounded-xl border border-gray-100">
                    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center gap-3">
                            <div class="p-2 bg-blue-500 rounded-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900">Recent Patients</h3>
                                <p class="text-sm text-gray-600">Latest registered patients</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        @php
                            $recentPatients = \App\Models\Patient::latest()->limit(5)->get();
                        @endphp
                        
                        @if($recentPatients->count() > 0)
                            <div class="space-y-3">
                                @foreach($recentPatients as $patient)
                                    <a href="{{ route('patients.show', $patient) }}" class="block group">
                                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl hover:bg-blue-50 transition-colors duration-150 border border-transparent hover:border-blue-200">
                                            <div class="flex items-center gap-3">
                                                <div class="h-10 w-10 rounded-full bg-gradient-to-r from-blue-400 to-indigo-500 flex items-center justify-center text-white font-semibold">
                                                    {{ strtoupper(substr($patient->first_name, 0, 1)) }}{{ strtoupper(substr($patient->last_name, 0, 1)) }}
                                                </div>
                                                <div>
                                                    <p class="text-sm font-semibold text-gray-900 group-hover:text-blue-700">{{ $patient->full_name }}</p>
                                                    <p class="text-xs text-gray-500">ID: {{ $patient->patient_id }}</p>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <p class="text-xs text-gray-500">{{ $patient->created_at->format('M d, Y') }}</p>
                                                <p class="text-xs text-blue-600 font-medium mt-1">View →</p>
                                            </div>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                            <div class="mt-4">
                                <a href="{{ route('patients.index') }}" class="block text-center text-sm text-blue-600 hover:text-blue-700 font-medium py-2">
                                    View all patients →
                                </a>
                            </div>
                        @else
                            <div class="text-center py-12">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <p class="mt-2 text-sm font-medium text-gray-900">No patients registered yet</p>
                                <p class="mt-1 text-sm text-gray-500">Get started by registering a new patient.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Recent Medical Records -->
                <div class="bg-white overflow-hidden shadow-xl rounded-xl border border-gray-100">
                    <div class="bg-gradient-to-r from-purple-50 to-pink-50 px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center gap-3">
                            <div class="p-2 bg-purple-500 rounded-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900">Recent Medical Records</h3>
                                <p class="text-sm text-gray-600">Latest patient visits</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        @php
                            $recentRecords = \App\Models\MedicalRecord::with(['patient', 'doctor'])->latest()->limit(5)->get();
                        @endphp
                        
                        @if($recentRecords->count() > 0)
                            <div class="space-y-3">
                                @foreach($recentRecords as $record)
                                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl hover:bg-purple-50 transition-colors duration-150 border border-transparent hover:border-purple-200">
                                        <div class="flex-1">
                                            <p class="text-sm font-semibold text-gray-900">{{ $record->patient->full_name }}</p>
                                            <p class="text-xs text-gray-500 mt-1">{{ $record->visit_type }} • {{ $record->doctor->name }}</p>
                                        </div>
                                        <div class="text-right">
                                            <p class="text-xs text-gray-500">{{ $record->visit_date->format('M d, Y') }}</p>
                                            <p class="text-xs text-gray-400 mt-1">{{ $record->visit_date->diffForHumans() }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-12">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <p class="mt-2 text-sm font-medium text-gray-900">No medical records yet</p>
                                <p class="mt-1 text-sm text-gray-500">Medical records will appear here as they are created.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
