import './bootstrap';

// Handle session expiration
document.addEventListener('DOMContentLoaded', function() {
    // Handle Livewire session expiration
    window.addEventListener('livewire:error', function(event) {
        if (event.detail.status === 401 || event.detail.status === 403) {
            const response = event.detail.response;
            if (response && response.redirect) {
                window.location.href = response.redirect;
            } else {
                window.location.href = '/login';
            }
        }
    });

    // Handle AJAX session expiration
    document.addEventListener('ajaxComplete', function(event) {
        const xhr = event.detail.xhr;
        if (xhr.status === 401 || xhr.status === 403) {
            try {
                const response = JSON.parse(xhr.responseText);
                if (response.redirect) {
                    window.location.href = response.redirect;
                } else {
                    window.location.href = '/login';
                }
            } catch (e) {
                if (xhr.status === 401) {
                    window.location.href = '/login';
                }
            }
        }
    });

    // Intercept fetch requests for session expiration
    const originalFetch = window.fetch;
    window.fetch = function(...args) {
        return originalFetch.apply(this, args).then(response => {
            if (response.status === 401 || response.status === 403) {
                response.json().then(data => {
                    if (data.redirect) {
                        window.location.href = data.redirect;
                    } else {
                        window.location.href = '/login';
                    }
                }).catch(() => {
                    if (response.status === 401) {
                        window.location.href = '/login';
                    }
                });
            }
            return response;
        });
    };
});
