<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            // Consultation Services
            [
                'code' => 'CONSULT_INITIAL',
                'name' => 'Initial Consultation',
                'category' => 'consultation',
                'subcategory' => 'initial',
                'service_key' => 'initial',
                'price' => 50.00,
                'unit' => 'per_unit',
                'description' => 'Initial patient consultation fee',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'code' => 'CONSULT_FOLLOWUP',
                'name' => 'Follow-up Consultation',
                'category' => 'consultation',
                'subcategory' => 'follow_up',
                'service_key' => 'follow_up',
                'price' => 30.00,
                'unit' => 'per_unit',
                'description' => 'Follow-up consultation fee',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'code' => 'CONSULT_EMERGENCY',
                'name' => 'Emergency Consultation',
                'category' => 'consultation',
                'subcategory' => 'emergency',
                'service_key' => 'emergency',
                'price' => 100.00,
                'unit' => 'per_unit',
                'description' => 'Emergency consultation fee',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'code' => 'CONSULT_TELEMEDICINE',
                'name' => 'Telemedicine Consultation',
                'category' => 'consultation',
                'subcategory' => 'telemedicine',
                'service_key' => 'telemedicine',
                'price' => 40.00,
                'unit' => 'per_unit',
                'description' => 'Telemedicine consultation fee',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'code' => 'CONSULT_SPECIALIST',
                'name' => 'Specialist Consultation',
                'category' => 'consultation',
                'subcategory' => 'specialist',
                'service_key' => 'specialist',
                'price' => 75.00,
                'unit' => 'per_unit',
                'description' => 'Specialist consultation fee',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'code' => 'CONSULT_GENERAL',
                'name' => 'General Consultation',
                'category' => 'consultation',
                'subcategory' => null,
                'service_key' => null,
                'price' => 50.00,
                'unit' => 'per_unit',
                'description' => 'General consultation fee (fallback)',
                'is_active' => true,
                'sort_order' => 0,
            ],

            // Lab Test Services
            [
                'code' => 'LAB_GENERAL',
                'name' => 'General Lab Test',
                'category' => 'lab_test',
                'subcategory' => null,
                'service_key' => null,
                'price' => 25.00,
                'unit' => 'per_unit',
                'description' => 'General lab test fee',
                'is_active' => true,
                'sort_order' => 0,
            ],
            [
                'code' => 'LAB_BLOOD_TEST',
                'name' => 'Blood Test',
                'category' => 'lab_test',
                'subcategory' => 'blood_test',
                'service_key' => null,
                'price' => 30.00,
                'unit' => 'per_unit',
                'description' => 'Blood test fee',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'code' => 'LAB_URINE_TEST',
                'name' => 'Urine Test',
                'category' => 'lab_test',
                'subcategory' => 'urine_test',
                'service_key' => null,
                'price' => 20.00,
                'unit' => 'per_unit',
                'description' => 'Urine test fee',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'code' => 'LAB_IMAGING',
                'name' => 'Imaging Test',
                'category' => 'lab_test',
                'subcategory' => 'imaging',
                'service_key' => null,
                'price' => 50.00,
                'unit' => 'per_unit',
                'description' => 'Imaging test fee (X-Ray, Ultrasound, CT, MRI)',
                'is_active' => true,
                'sort_order' => 3,
            ],

            // Prescription Services
            [
                'code' => 'PRESC_GENERAL',
                'name' => 'Prescription Fee',
                'category' => 'prescription',
                'subcategory' => null,
                'service_key' => null,
                'price' => 10.00,
                'unit' => 'per_quantity',
                'description' => 'Prescription fee per item quantity',
                'is_active' => true,
                'sort_order' => 1,
            ],
        ];

        foreach ($services as $service) {
            Service::updateOrCreate(
                ['code' => $service['code']],
                $service
            );
        }
    }
}
