<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'Doctor',
                'slug' => 'doctor',
                'description' => 'Medical doctor with full patient care access',
            ],
            [
                'name' => 'Nurse',
                'slug' => 'nurse',
                'description' => 'Nursing staff with patient care and medication administration access',
            ],
            [
                'name' => 'Front Desk',
                'slug' => 'front_desk',
                'description' => 'Front desk staff with patient registration and appointment management access',
            ],
            [
                'name' => 'Developer',
                'slug' => 'developer',
                'description' => 'System developer with full administrative access',
            ],
            [
                'name' => 'Chief Medical Director',
                'slug' => 'cmd',
                'description' => 'Chief Medical Director with full system access',
            ],
            [
                'name' => 'Pharmacy Staff',
                'slug' => 'pharmacy',
                'description' => 'Pharmacy staff with prescription dispensing access',
            ],
            [
                'name' => 'Billing Staff',
                'slug' => 'billing',
                'description' => 'Billing staff with billing and payment processing access',
            ],
            [
                'name' => 'Lab Staff',
                'slug' => 'lab',
                'description' => 'Laboratory staff with lab request processing access',
            ],
            [
                'name' => 'Staff',
                'slug' => 'staff',
                'description' => 'General staff member',
            ],
        ];

        foreach ($roles as $role) {
            Role::updateOrCreate(
                ['slug' => $role['slug']],
                $role
            );
        }
    }
}
