<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\OperationRoom;

class OperationRoomSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $rooms = [
            [
                'room_number' => 'OR-001',
                'name' => 'Operating Room 1',
                'description' => 'Main operating theater with advanced equipment',
                'status' => OperationRoom::STATUS_AVAILABLE,
                'equipment' => ['Anesthesia Machine', 'Ventilator', 'Surgical Lights', 'Monitor'],
                'capacity' => 1,
                'is_active' => true,
            ],
            [
                'room_number' => 'OR-002',
                'name' => 'Operating Room 2',
                'description' => 'Secondary operating theater',
                'status' => OperationRoom::STATUS_AVAILABLE,
                'equipment' => ['Anesthesia Machine', 'Ventilator', 'Surgical Lights', 'Monitor'],
                'capacity' => 1,
                'is_active' => true,
            ],
            [
                'room_number' => 'OR-003',
                'name' => 'Operating Room 3',
                'description' => 'Minor procedures room',
                'status' => OperationRoom::STATUS_AVAILABLE,
                'equipment' => ['Anesthesia Machine', 'Surgical Lights', 'Monitor'],
                'capacity' => 1,
                'is_active' => true,
            ],
            [
                'room_number' => 'OR-004',
                'name' => 'Operating Room 4',
                'description' => 'Emergency operating theater',
                'status' => OperationRoom::STATUS_AVAILABLE,
                'equipment' => ['Anesthesia Machine', 'Ventilator', 'Surgical Lights', 'Monitor', 'Defibrillator'],
                'capacity' => 1,
                'is_active' => true,
            ],
        ];

        foreach ($rooms as $room) {
            OperationRoom::updateOrCreate(
                ['room_number' => $room['room_number']],
                $room
            );
        }
    }
}
