<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create test users
        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // Seed roles first
        $this->call([
            RoleSeeder::class,
        ]);

        // Seed drug categories
        $this->call([
            DrugCategorySeeder::class,
        ]);

        // Seed healthcare data
        $this->call([
            HealthcareDataSeeder::class,
        ]);
    }
}
