<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('medication_administrations', function (Blueprint $table) {
            $table->foreignId('prescription_id')->nullable()->after('admission_id')->constrained()->onDelete('set null');
            $table->index('prescription_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('medication_administrations', function (Blueprint $table) {
            $table->dropForeign(['prescription_id']);
            $table->dropIndex(['prescription_id']);
            $table->dropColumn('prescription_id');
        });
    }
};
