<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('operation_rooms', function (Blueprint $table) {
            $table->string('room_number')->unique()->after('id');
            $table->string('name')->after('room_number');
            $table->text('description')->nullable()->after('name');
            $table->enum('status', ['available', 'occupied', 'maintenance', 'unavailable'])->default('available')->after('description');
            $table->json('equipment')->nullable()->after('status');
            $table->integer('capacity')->default(1)->after('equipment');
            $table->boolean('is_active')->default(true)->after('capacity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('operation_rooms', function (Blueprint $table) {
            $table->dropColumn([
                'room_number',
                'name',
                'description',
                'status',
                'equipment',
                'capacity',
                'is_active',
            ]);
        });
    }
};
