<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique(); // e.g., CONSULT_INITIAL, LAB_CBC, PRESC_GENERAL
            $table->string('name'); // Display name
            $table->string('category'); // consultation, lab_test, prescription, other
            $table->string('subcategory')->nullable(); // consultation_type, test_type, etc.
            $table->string('service_key')->nullable(); // For matching: consultation_type, test_name, drug_id, etc.
            $table->decimal('price', 10, 2); // Service price
            $table->string('unit')->default('per_unit'); // per_unit, per_quantity, per_hour, etc.
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            
            // Indexes
            $table->index('category');
            $table->index('subcategory');
            $table->index('service_key');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
