<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('security_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('event_type'); // 'login', 'logout', 'failed_login', 'unauthorized_access', 'data_access', 'data_modification', 'password_change', etc.
            $table->string('severity')->default('info'); // 'info', 'warning', 'critical'
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->text('description')->nullable();
            $table->json('metadata')->nullable(); // Additional event data
            $table->string('resource_type')->nullable(); // Model type
            $table->unsignedBigInteger('resource_id')->nullable(); // Model ID
            $table->timestamps();
            
            // Indexes for performance
            $table->index('user_id');
            $table->index('event_type');
            $table->index('severity');
            $table->index('created_at');
            $table->index(['resource_type', 'resource_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('security_events');
    }
};
