<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // Who made the change
            $table->foreignId('patient_id')->constrained()->onDelete('cascade'); // Which patient
            $table->foreignId('visit_id')->nullable()->constrained()->onDelete('set null'); // Which visit (if applicable)
            $table->string('model_type'); // e.g., 'App\Models\Patient'
            $table->unsignedBigInteger('model_id'); // ID of the model being changed
            $table->string('action'); // 'created', 'updated', 'deleted'
            $table->string('field_name'); // 'medical_history', 'allergies', etc.
            $table->text('old_value')->nullable(); // Previous value
            $table->text('new_value')->nullable(); // New value
            $table->text('description')->nullable(); // Human-readable description
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
            
            // Indexes for performance
            $table->index('patient_id');
            $table->index('visit_id');
            $table->index('user_id');
            $table->index('model_type');
            $table->index('field_name');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audit_logs');
    }
};
