<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drugs', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('generic_name');
            $table->string('manufacturer');
            $table->string('category');
            $table->text('description')->nullable();
            $table->string('dosage_form');
            $table->string('strength');
            $table->string('unit');
            $table->boolean('prescription_required')->default(true);
            $table->json('side_effects')->nullable();
            $table->json('contraindications')->nullable();
            $table->json('interactions')->nullable();
            $table->text('storage_conditions')->nullable();
            $table->integer('expiry_alert_days')->default(30);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drugs');
    }
};
