<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('doctor_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('drug_id')->constrained()->onDelete('cascade');
            $table->string('prescription_number')->unique();
            $table->string('dosage');
            $table->string('frequency');
            $table->integer('duration'); // in days
            $table->integer('quantity');
            $table->text('instructions')->nullable();
            $table->date('prescription_date');
            $table->date('valid_until');
            $table->enum('status', ['active', 'dispensed', 'expired', 'cancelled'])->default('active');
            $table->text('notes')->nullable();
            $table->integer('refill_count')->default(0);
            $table->integer('max_refills')->default(0);
            $table->text('pharmacy_notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescriptions');
    }
};
