<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MedicationAdministration extends Model
{
    use HasFactory;

    protected $fillable = [
        'admission_id',
        'prescription_id',
        'medication_name',
        'dosage',
        'route',
        'time_administered',
        'nurse_id',
        'notes',
    ];

    protected $casts = [
        'time_administered' => 'datetime',
    ];

    /**
     * Relationships
     */
    public function admission(): BelongsTo
    {
        return $this->belongsTo(Admission::class);
    }

    public function nurse(): BelongsTo
    {
        return $this->belongsTo(User::class, 'nurse_id');
    }

    public function prescription(): BelongsTo
    {
        return $this->belongsTo(Prescription::class);
    }

    /**
     * Get route display name
     */
    public function getRouteDisplayAttribute(): string
    {
        return ucfirst(strtolower($this->route));
    }
}
