<?php

namespace App\Livewire\Visits;

use App\Models\Visit;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.app')]
class VisitShow extends Component
{
    public Visit $visit;

    public function mount(Visit $visit)
    {
        $this->visit = $visit->load([
            'patient',
            'createdBy',
            'consultations.doctor',
            'prescriptions.doctor',
            'prescriptions.drug',
            'labRequests.requestedBy',
            'bills.payments',
            'medicalRecords.doctor',
            'admission'
        ]);
    }

    public function render()
    {
        return view('livewire.visits.visit-show');
    }
}
