<?php

namespace App\Livewire\Dashboard;

use App\Models\Bill;
use App\Models\Appointment;
use App\Models\Visit;
use Livewire\Component;

class PendingTasks extends Component
{
    public function render()
    {
        $pendingBills = collect();
        $pendingAppointments = collect();
        $pendingVisitsForNurse = collect();
        $pendingVisitsForDoctor = collect();
        
        $user = auth()->user();
        
        if ($user->isNurse()) {
            // For nurses, show pending visits waiting for vitals
            $pendingVisitsForNurse = Visit::with(['patient', 'createdBy'])
                ->whereIn('status', [Visit::STATUS_CHECKED_IN, Visit::STATUS_WAITING_NURSE])
                ->whereNull('checked_out_at')
                ->orderBy('checked_in_at', 'asc')
                ->limit(5)
                ->get();
        } elseif ($user->isDoctor()) {
            // For doctors, show patients waiting for consultation
            $pendingVisitsForDoctor = Visit::with(['patient', 'createdBy'])
                ->whereIn('status', [Visit::STATUS_WAITING_DOCTOR, Visit::STATUS_IN_CONSULTATION])
                ->whereNull('checked_out_at')
                ->orderBy('checked_in_at', 'asc')
                ->limit(5)
                ->get();
        } else {
            // For front desk, billing, and other roles
            if ($user->canViewBills()) {
                $pendingBills = Bill::where('status', 'pending')
                    ->with('patient')
                    ->limit(5)
                    ->get();
            }
            
            if ($user->canViewAppointments()) {
                $pendingAppointments = Appointment::where('status', 'scheduled')
                    ->whereDate('appointment_date', '>=', today())
                    ->with('patient')
                    ->limit(3)
                    ->get();
            }
        }
        
        $totalPending = $pendingBills->count() + $pendingVisitsForNurse->count() + $pendingVisitsForDoctor->count();
        
        return view('livewire.dashboard.pending-tasks', [
            'pendingBills' => $pendingBills,
            'pendingAppointments' => $pendingAppointments,
            'pendingVisitsForNurse' => $pendingVisitsForNurse,
            'pendingVisitsForDoctor' => $pendingVisitsForDoctor,
            'totalPending' => $totalPending,
        ]);
    }
}
