<?php

namespace App\Livewire\Actions;

use App\Services\SecurityEventService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class Logout
{
    /**
     * Log the current user out of the application.
     */
    public function __invoke(): void
    {
        // Log logout event before logging out
        if (Auth::check()) {
            SecurityEventService::logLogout();
        }

        Auth::guard('web')->logout();

        Session::invalidate();
        Session::regenerateToken();
    }
}
